/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util.typemapping;

import cn.org.rapid_framework.generator.provider.java.model.JavaClass;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.typemapping.JavaPrimitiveTypeMapping;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImport {
    TreeSet<String> imports = new TreeSet();

    public void addImport(String javaType) {
        if (JavaImport.isNeedImport(javaType)) {
            this.imports.add(javaType.replace("$", "."));
        }
    }

    public void addImport(JavaImport javaImport) {
        if (javaImport != null) {
            this.imports.addAll(javaImport.getImports());
        }
    }

    public TreeSet<String> getImports() {
        return this.imports;
    }

    public static void addImportClass(Set<JavaClass> set, Class ... clazzes) {
        if (clazzes == null) {
            return;
        }
        for (Class c : clazzes) {
            if (c == null || c.getName().startsWith("java.lang.") || c.isPrimitive() || "void".equals(c.getName()) || c.isAnonymousClass() || !Modifier.isPublic(c.getModifiers()) || !JavaImport.isNeedImport(c.getName())) continue;
            set.add(new JavaClass(c));
        }
    }

    public static boolean isNeedImport(String type) {
        if (StringHelper.isBlank(type)) {
            return false;
        }
        if ("void".equals(type)) {
            return false;
        }
        if (type.startsWith("java.lang.")) {
            return false;
        }
        if (JavaPrimitiveTypeMapping.getPrimitiveTypeOrNull(type) != null) {
            return false;
        }
        return type.indexOf(".") >= 0 && !Character.isLowerCase(StringHelper.getJavaClassSimpleName(type).charAt(0));
    }
}

