/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util.test;

import cn.org.rapid_framework.generator.Generator;
import cn.org.rapid_framework.generator.GeneratorFacade;
import cn.org.rapid_framework.generator.provider.db.sql.model.Sql;
import cn.org.rapid_framework.generator.util.FileHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class GeneratorTestHelper {
    private static AtomicLong count = new AtomicLong(System.currentTimeMillis());

    public static String generateBy(GeneratorFacade gf, Generator.GeneratorModel ... models) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        gf.getGenerator().setOutRootDir(tempDir.getPath());
        gf.generateBy(models);
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, gf.getGenerator().getOutputEncoding());
    }

    public static String generateByAllTable(GeneratorFacade gf) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        gf.getGenerator().setOutRootDir(tempDir.getPath());
        gf.generateByAllTable();
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, gf.getGenerator().getOutputEncoding());
    }

    public static String generateByClass(GeneratorFacade gf, Class ... clazzes) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        gf.getGenerator().setOutRootDir(tempDir.getPath());
        gf.generateByClass(clazzes);
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, gf.getGenerator().getOutputEncoding());
    }

    public static String generateByMap(GeneratorFacade gf, Map ... maps) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        gf.getGenerator().setOutRootDir(tempDir.getPath());
        gf.generateByMap(maps);
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, gf.getGenerator().getOutputEncoding());
    }

    public static String generateBySql(GeneratorFacade gf, Sql ... sqls) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        gf.getGenerator().setOutRootDir(tempDir.getPath());
        gf.generateBySql(sqls);
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, gf.getGenerator().getOutputEncoding());
    }

    public static String generateByTable(GeneratorFacade gf, String ... tableNames) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        gf.getGenerator().setOutRootDir(tempDir.getPath());
        gf.generateByTable(tableNames);
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, gf.getGenerator().getOutputEncoding());
    }

    public static String generateBy(Generator g, Map templateModel) throws Exception {
        return GeneratorTestHelper.generateBy(g, templateModel, templateModel);
    }

    public static String generateBy(Generator g, Map templateModel, Map filePathModel) throws Exception {
        File tempDir = GeneratorTestHelper.getOutputTempDir();
        g.setOutRootDir(tempDir.getPath());
        g.generateBy(templateModel, filePathModel);
        return GeneratorTestHelper.readEntireDirectoryContentAndDelete(tempDir, g.getOutputEncoding());
    }

    private static String readEntireDirectoryContentAndDelete(File tempDir, String encoding) {
        String result = FileHelper.readEntireDirectoryContent(tempDir, encoding);
        List<File> files = FileHelper.searchAllNotIgnoreFile(tempDir);
        for (File f : files) {
            String relativePath;
            if (f.isDirectory() || StringHelper.isBlank(relativePath = FileHelper.getRelativePath(tempDir, f).replace('\\', '/'))) continue;
            result = result + "\n" + "file:" + relativePath;
        }
        try {
            FileHelper.deleteDirectory(tempDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static File getOutputTempDir() {
        File tempDir = new File(FileHelper.getTempDir(), "GeneratorTestHelper/" + count.incrementAndGet() + ".tmp");
        tempDir.deleteOnExit();
        return tempDir;
    }
}

