/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util.sqlparse;

import cn.org.rapid_framework.generator.provider.db.sql.model.SqlParameter;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.sqlparse.SqlParseHelper;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementCreatorUtils {
    static Random random = new Random(System.currentTimeMillis());

    public static Object getRandomValue(int sqlType, Integer scale) {
        switch (sqlType) {
            case -7: 
            case -6: 
            case 5: {
                return (byte)StatementCreatorUtils.randomNumber();
            }
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return StatementCreatorUtils.randomNumber();
            }
            case 91: 
            case 92: 
            case 93: {
                return StatementCreatorUtils.now();
            }
            case 1: 
            case 12: {
                return StatementCreatorUtils.randomString(scale);
            }
            case -1: 
            case 2005: {
                return null;
            }
            case -15: 
            case -9: 
            case 2011: {
                return null;
            }
            case -4: 
            case -3: 
            case -2: {
                return null;
            }
            case 0: 
            case 1111: 
            case 2004: {
                return null;
            }
            case 16: {
                return false;
            }
            case -2147482648: 
            case -10: {
                return null;
            }
        }
        return null;
    }

    public static int randomNumber() {
        return Math.abs(random.nextInt());
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String randomString(Integer count) {
        if (count == null || count <= 0) {
            count = 1;
        }
        String result = "";
        for (int i = 0; i < count; ++i) {
            result = result + "" + Math.abs(StatementCreatorUtils.randomNumber()) % 9;
        }
        return result;
    }

    public static void setParameterRandomValue(PreparedStatement ps, int parameterIndex, int sqlType, Integer scale) throws SQLException {
        Object v = StatementCreatorUtils.getRandomValue(sqlType, scale);
        if (v == null) {
            ps.setNull(parameterIndex, 0);
        } else if (v instanceof String) {
            ps.setString(parameterIndex, (String)v);
        } else if (v instanceof Timestamp) {
            ps.setTimestamp(parameterIndex, (Timestamp)v);
        } else if (v instanceof Number) {
            ps.setByte(parameterIndex, ((Number)v).byteValue());
        } else {
            ps.setObject(parameterIndex, v);
        }
    }

    public static void setRandomParamsValueForPreparedStatement(String executeSql, PreparedStatement ps, List<SqlParameter> params) throws SQLException {
        int count = StringHelper.containsCount(SqlParseHelper.removeOrders(executeSql), "?");
        if (count == 0) {
            return;
        }
        SqlParameter[] sqlParameters = params.toArray(new SqlParameter[0]);
        for (int parameterIndex = 1; parameterIndex <= count; ++parameterIndex) {
            int index = parameterIndex - 1;
            if (index < sqlParameters.length) {
                SqlParameter parameter = sqlParameters[index];
                StatementCreatorUtils.setParameterRandomValue(ps, parameterIndex, parameter.getSqlType(), parameter.getSize());
                continue;
            }
            ps.setObject(parameterIndex, null);
        }
    }
}

