/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util.sqlparse;

import cn.org.rapid_framework.generator.provider.db.table.TableFactory;
import cn.org.rapid_framework.generator.util.GLogger;
import cn.org.rapid_framework.generator.util.IOHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.sqlparse.SqlTypeChecker;
import java.io.StringReader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlParseHelper {
    static Pattern fromRegex = Pattern.compile("(\\sfrom\\s+)([,\\w]+)", 2);
    static Pattern join = Pattern.compile("(join\\s+)(\\w+)(as)?(\\w*)", 2);
    static Pattern update = Pattern.compile("(\\s*update\\s+)(\\w+)", 2);
    static Pattern insert = Pattern.compile("(\\s*insert\\s+into\\s+)(\\w+)", 2);
    public static long startTimes = System.currentTimeMillis();

    public static Set<NameWithAlias> getTableNamesByQuery(String sql) {
        sql = SqlParseHelper.removeSqlComments(StringHelper.removeXMLCdataTag(sql)).trim();
        LinkedHashSet<NameWithAlias> result = new LinkedHashSet<NameWithAlias>();
        Matcher m = fromRegex.matcher(sql);
        if (m.find()) {
            String from = SqlParseHelper.getFromClauses(sql);
            if (from.matches("(?ims).*\\sfrom\\s.*")) {
                return SqlParseHelper.getTableNamesByQuery(from);
            }
            if (from.indexOf(44) >= 0) {
                String[] array;
                for (String s : array = StringHelper.tokenizeToStringArray(from, ",")) {
                    result.add(SqlParseHelper.parseTableSqlAlias(s));
                }
            } else if (StringHelper.indexOfByRegex(from.toLowerCase(), "\\sjoin\\s") >= 0) {
                String[] joins;
                String removedFrom = StringHelper.removeMany(from.toLowerCase(), "inner", "full", "left", "right", "outer");
                for (String s : joins = removedFrom.split("join")) {
                    result.add(SqlParseHelper.parseTableSqlAlias(s));
                }
            } else {
                result.add(SqlParseHelper.parseTableSqlAlias(from));
            }
        }
        if (SqlTypeChecker.isUpdateSql(sql) && (m = update.matcher(sql)).find()) {
            result.add(new NameWithAlias(m.group(2), null));
        }
        if (SqlTypeChecker.isInsertSql(sql) && (m = insert.matcher(sql)).find()) {
            result.add(new NameWithAlias(m.group(2), null));
        }
        return result;
    }

    public static NameWithAlias parseTableSqlAlias(String str) {
        try {
            str = str.trim();
            String[] array = str.split("\\sas\\s");
            if (array.length >= 2 && str.matches("^[\\w_]+\\s+as\\s+[_\\w]+.*")) {
                return new NameWithAlias(array[0], StringHelper.tokenizeToStringArray(array[1], " \n\t")[0]);
            }
            array = StringHelper.tokenizeToStringArray(str, " \n\t");
            if (array.length >= 2 && str.matches("^[\\w_]+\\s+[_\\w]+.*")) {
                return new NameWithAlias(array[0], array[1]);
            }
            return new NameWithAlias(StringHelper.getByRegex(str.trim(), "^[\\w_]+"), StringHelper.getByRegex(str.trim(), "^[\\w_]+\\s+([\\w_]+)", 1));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("parseTableSqlAlias error,str:" + str, e);
        }
    }

    public static String getParameterClassName(String sql, String paramName) {
        Pattern p = Pattern.compile("(:)(" + paramName + ")(\\|?)([\\w.]+)");
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.group(4);
        }
        return null;
    }

    public static String getColumnNameByRightCondition(String sql, String column) {
        String operator = "[=<>!]{1,2}";
        String result = SqlParseHelper.getColumnNameByRightCondition(sql, column, operator);
        if (result == null) {
            result = SqlParseHelper.getColumnNameByRightCondition(sql, column, "\\s+like\\s+");
        }
        if (result == null) {
            result = SqlParseHelper.getColumnNameByRightCondition(sql, column, "\\s+between\\s+");
        }
        if (result == null) {
            result = SqlParseHelper.getColumnNameByRightCondition(sql, column, "\\s+between\\s.+\\sand\\s+");
        }
        if (result == null) {
            result = SqlParseHelper.getColumnNameByRightCondition(sql, column, "\\s+not\\s+in\\s*\\(");
        }
        if (result == null) {
            result = SqlParseHelper.getColumnNameByRightCondition(sql, column, "\\s+in\\s*\\(");
        }
        if (result == null) {
            result = SqlParseHelper.getColumnNameByRightConditionWithFunction(sql, column, operator);
        }
        return result;
    }

    private static String getColumnNameByRightConditionWithFunction(String sql, String column, String operator) {
        Pattern p = Pattern.compile("(\\w+)\\s*" + operator + "\\s*\\w+\\([,\\w]*[:#$&]\\{?" + column + "[\\}#$]?[,\\w]*\\)", 34);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static String getColumnNameByRightCondition(String sql, String column, String operator) {
        Pattern p = Pattern.compile("(\\w+)\\s*" + operator + "\\s*[:#$&]\\{?" + column + "[\\}#$]?", 34);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String convert2NamedParametersSql(String sql, String prefix, String suffix) {
        return new NamedSqlConverter(prefix, suffix).convert2NamedParametersSql(sql);
    }

    public static String getPrettySql(String sql) {
        try {
            if (IOHelper.readLines(new StringReader(sql)).size() > 1) {
                return sql;
            }
            return StringHelper.replace(StringHelper.replace(sql, "from", "\n\tfrom"), "where", "\n\twhere");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeSelect(String sql) {
        if (StringHelper.isBlank(sql)) {
            throw new IllegalArgumentException("sql must be not empty");
        }
        int beginPos = StringHelper.indexOfByRegex(sql.toLowerCase(), "\\sfrom\\s");
        if (beginPos == -1) {
            throw new IllegalArgumentException(" sql : " + sql + " must has a keyword 'from'");
        }
        return sql.substring(beginPos);
    }

    public static String toCountSqlForPaging(String sql, String countQueryPrefix) {
        if (StringHelper.isBlank(sql)) {
            throw new IllegalArgumentException("sql must be not empty");
        }
        if (StringHelper.indexOfByRegex(sql.toLowerCase(), "\\sgroup\\s+by\\s") >= 0) {
            return countQueryPrefix + " from (" + sql + " ) forGroupByCountTable";
        }
        int selectBeginOps = StringHelper.indexOfByRegex(sql.toLowerCase(), "select\\s");
        int fromBeingOps = StringHelper.indexOfByRegex(sql.toLowerCase(), "\\sfrom\\s");
        if (fromBeingOps == -1) {
            throw new IllegalArgumentException(" sql : " + sql + " must has a keyword 'from'");
        }
        return sql.substring(0, selectBeginOps) + countQueryPrefix + sql.substring(fromBeingOps);
    }

    public static String getSelect(String sql) {
        if (StringHelper.isBlank(sql)) {
            throw new IllegalArgumentException("sql must be not empty");
        }
        int beginPos = StringHelper.indexOfByRegex(sql.toLowerCase(), "\\sfrom\\s");
        if (beginPos == -1) {
            throw new IllegalArgumentException(" sql : " + sql + " must has a keyword 'from'");
        }
        return sql.substring(0, beginPos);
    }

    public static String getFromClauses(String sql) {
        String lowerSql = sql.toLowerCase();
        int fromBegin = StringHelper.indexOfByRegex(lowerSql, "\\sfrom\\s");
        if (fromBegin <= 0) {
            throw new IllegalArgumentException("error from begin:" + fromBegin);
        }
        int fromEnd = lowerSql.indexOf("where");
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\sgroup\\s+by\\s");
        }
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\shaving\\s");
        }
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\sorder\\s+by\\s");
        }
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\sunion\\s");
        }
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\sintersect\\s");
        }
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\sminus\\s");
        }
        if (fromEnd == -1) {
            fromEnd = StringHelper.indexOfByRegex(lowerSql, "\\sexcept\\s");
        }
        if (fromEnd == -1) {
            fromEnd = sql.length();
        }
        return sql.substring(fromBegin + " from ".length(), fromEnd);
    }

    public static String removeSqlComments(String sql) {
        if (sql == null) {
            return null;
        }
        return sql.replaceAll("(?s)/\\*.*?\\*/", "").replaceAll("--.*", "");
    }

    public static String removeOrders(String sql) {
        return sql.replaceAll("(?is)order\\s+by[\\w|\\W|\\s|\\S]*", "");
    }

    public static String replaceWhere(String sql) {
        return sql.toString().replaceAll("(?i)\\swhere\\s+(and|or)\\s", " WHERE ");
    }

    public static void setRandomParamsValueForPreparedStatement(String sql, PreparedStatement ps) throws SQLException {
        int count = StringHelper.containsCount(sql, "?");
        if (TableFactory.DatabaseMetaDataUtils.isOracleDataBase(ps.getConnection().getMetaData()) && SqlTypeChecker.isSelectSql(sql)) {
            for (int i = 1; i <= count; ++i) {
                ps.setObject(i, null);
            }
            return;
        }
        for (int i = 1; i <= count; ++i) {
            long random = (long)(new Random(System.currentTimeMillis() + startTimes++).nextInt() * 30) + System.currentTimeMillis() + startTimes;
            try {
                ps.setLong(i, random);
                continue;
            }
            catch (SQLException e) {
                try {
                    ps.setInt(i, (int)random % Integer.MAX_VALUE);
                    continue;
                }
                catch (SQLException e1) {
                    try {
                        ps.setString(i, "" + random);
                        continue;
                    }
                    catch (SQLException e2) {
                        try {
                            ps.setTimestamp(i, new Timestamp(random));
                            continue;
                        }
                        catch (SQLException e3) {
                            try {
                                ps.setDate(i, new Date(random));
                                continue;
                            }
                            catch (SQLException e6) {
                                try {
                                    ps.setString(i, "" + (int)random);
                                    continue;
                                }
                                catch (SQLException e4) {
                                    try {
                                        ps.setString(i, "" + (short)random);
                                        continue;
                                    }
                                    catch (SQLException e82) {
                                        try {
                                            ps.setString(i, "" + (byte)random);
                                            continue;
                                        }
                                        catch (SQLException e32) {
                                            try {
                                                ps.setNull(i, 1111);
                                                continue;
                                            }
                                            catch (SQLException error) {
                                                SqlParseHelper.warn(sql, i, error);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void warn(String sql, int i, SQLException error) {
        GLogger.warn("error on set parametet index:" + i + " cause:" + error + " sql:" + sql);
    }

    public static class NamedSqlConverter {
        private String prefix;
        private String suffix;

        public NamedSqlConverter(String prefix, String suffix) {
            if (prefix == null) {
                throw new NullPointerException("'prefix' must be not null");
            }
            if (suffix == null) {
                throw new NullPointerException("'suffix' must be not null");
            }
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String convert2NamedParametersSql(String sql) {
            if (sql.trim().toLowerCase().matches("(?is)\\s*insert\\s+into\\s+.*")) {
                return this.replace2NamedParameters(this.replaceInsertSql2NamedParameters(sql));
            }
            return this.replace2NamedParameters(sql);
        }

        private String replace2NamedParameters(String sql) {
            String replacedSql = this.replace2NamedParametersByOperator(sql, "[=<>!]{1,2}");
            replacedSql = this.replace2NamedParametersByOperator(replacedSql, "\\s+like\\s+");
            return replacedSql;
        }

        private String replaceInsertSql2NamedParameters(String sql) {
            if (sql.matches("(?is)\\s*insert\\s+into\\s+\\w+\\s+values\\s*\\(.*\\).*")) {
                if (sql.indexOf("?") >= 0) {
                    throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7684insert sql:" + sql + ",values()\u6bb5\u6ca1\u6709\u5305\u542b\u7591\u95ee\u53f7?");
                }
                return sql;
            }
            String selectKeyPattern = "<selectKey.*";
            String insertPattern = "\\s*insert\\s+into.*\\((.*?)\\).*values.*?\\((.*)\\).*";
            Matcher m = NamedSqlConverter.matcher(sql, 34, insertPattern + selectKeyPattern, insertPattern);
            if (m != null) {
                Object[] values;
                Object[] columns = StringHelper.tokenizeToStringArray(m.group(1), ", \t\n\r\f");
                if (columns.length != (values = StringHelper.tokenizeToStringArray(m.group(2), ", \t\n\r\f")).length) {
                    throw new IllegalArgumentException("insert \u8bed\u53e5\u7684\u63d2\u5165\u5217\u4e0e\u503c\u5217\u6570\u76ee\u4e0d\u76f8\u7b49,sql:" + sql + " \ncolumns:" + StringHelper.join(columns, ",") + " \nvalues:" + StringHelper.join(values, ","));
                }
                for (int i = 0; i < columns.length; ++i) {
                    String column = columns[i];
                    String paranName = StringHelper.uncapitalize(StringHelper.makeAllWordFirstLetterUpperCase(column));
                    values[i] = ((String)values[i]).replace("?", this.prefix + paranName + this.suffix);
                }
                return StringHelper.replace(m.start(2), m.end(2), sql, StringHelper.join(values, ","));
            }
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7684sql:" + sql + ",\u4e0d\u5339\u914d\u6b63\u5219\u8868\u8fbe\u5f0f:" + insertPattern);
        }

        private static Matcher matcher(String input, int flags, String ... regexArray) {
            for (String regex : regexArray) {
                Pattern p = Pattern.compile(regex, flags);
                Matcher m = p.matcher(input);
                if (!m.find()) continue;
                return m;
            }
            return null;
        }

        private String replace2NamedParametersByOperator(String sql, String operator) {
            Pattern p = Pattern.compile("(\\w+)\\s*" + operator + "\\s*\\?", 34);
            Matcher m = p.matcher(sql);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String segment = m.group(0);
                String columnSqlName = m.group(1);
                String paramName = StringHelper.uncapitalize(StringHelper.makeAllWordFirstLetterUpperCase(columnSqlName));
                String replacedSegment = segment.replace("?", this.prefix + paramName + this.suffix);
                m.appendReplacement(sb, replacedSegment);
            }
            m.appendTail(sb);
            return sb.toString();
        }
    }

    public static class NameWithAlias {
        private String name;
        private String alias;

        public NameWithAlias(String name, String alias) {
            if (name == null) {
                throw new IllegalArgumentException("name must be not null");
            }
            if (name.trim().indexOf(32) >= 0) {
                throw new IllegalArgumentException("error name:" + name);
            }
            if (alias != null && alias.trim().indexOf(32) >= 0) {
                throw new IllegalArgumentException("error alias:" + alias);
            }
            this.name = name.trim();
            this.alias = alias == null ? null : alias.trim();
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return StringHelper.isBlank(this.alias) ? this.getName() : this.alias;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameWithAlias other = (NameWithAlias)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return StringHelper.isBlank(this.alias) ? this.name : this.name + " as " + this.alias;
        }
    }
}

