/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util.sqlparse;

import cn.org.rapid_framework.generator.util.sqlparse.ParsedSql;
import java.util.HashSet;
import java.util.List;

public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    public static ParsedSql parseSqlStatement(String sql) throws IllegalArgumentException {
        if (sql == null) {
            throw new IllegalArgumentException("SQL must not be null");
        }
        HashSet<String> namedParameters = new HashSet<String>();
        ParsedSql parsedSql = new ParsedSql(sql);
        char[] statement = sql.toCharArray();
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        int i = 0;
        while (i < statement.length) {
            char c;
            int skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i);
            if (i != skipToPosition) {
                if (skipToPosition >= statement.length) break;
                i = skipToPosition;
            }
            if ((c = statement[i]) == ':' || c == '&' || c == '#' || c == '$') {
                int j = i + 1;
                if (j < statement.length && statement[j] == ':' && c == ':') {
                    i += 2;
                    continue;
                }
                while (j < statement.length && !NamedParameterUtils.isParameterSeparator(statement[j])) {
                    ++j;
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    if (!namedParameters.contains(parameter)) {
                        namedParameters.add(parameter);
                        ++namedParameterCount;
                    }
                    String removedPrefixAndSuffixParameter = NamedParameterUtils.removePrefixAndSuffix(c, parameter, sql);
                    parsedSql.addNamedParameter(removedPrefixAndSuffixParameter, c + parameter, i, j);
                    ++totalParameterCount;
                }
                i = j - 1;
            } else if (c == '?') {
                ++unnamedParameterCount;
                ++totalParameterCount;
            }
            ++i;
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static String removePrefixAndSuffix(char startPrifix, String parameter, String sql) {
        if (startPrifix == ':' || startPrifix == '&') {
            return parameter;
        }
        if (parameter.startsWith("{") || parameter.endsWith("}")) {
            if (!parameter.startsWith("{") || !parameter.endsWith("}")) {
                throw new IllegalArgumentException("parameter error:" + parameter + ",must wrap with {param},sql:" + sql);
            }
            parameter = parameter.substring(1, parameter.length() - 1);
            return parameter.replaceAll("\\[.*?\\]", "");
        }
        if (startPrifix == '#') {
            if (!parameter.endsWith("#")) {
                throw new IllegalArgumentException("parameter error:" + parameter + ",must wrap with #param#,sql:" + sql);
            }
            parameter = parameter.substring(0, parameter.length() - 1);
            if (parameter.endsWith("[]")) {
                return parameter.substring(0, parameter.length() - 2);
            }
            return parameter;
        }
        if (startPrifix == '$') {
            if (!parameter.endsWith("$")) {
                throw new IllegalArgumentException("parameter error:" + parameter + ",must wrap with $param$,sql:" + sql);
            }
            parameter = parameter.substring(0, parameter.length() - 1);
            return parameter;
        }
        throw new IllegalArgumentException("cannot reach this");
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql) {
        String originalSql = parsedSql.getOriginalSql();
        StringBuilder actualSql = new StringBuilder();
        List<String> paramNames = parsedSql.getParameterNames();
        int lastIndex = 0;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql.substring(lastIndex, startIndex));
            actualSql.append("?");
            lastIndex = endIndex;
        }
        actualSql.append(originalSql.substring(lastIndex, originalSql.length()));
        return actualSql.toString();
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }
}

