/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util.paranamer;

import cn.org.rapid_framework.generator.util.IOHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.paranamer.Paranamer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceParanamer
implements Paranamer {
    private ClassLoader classLoader;

    public JavaSourceParanamer(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("'classLoader' must be not null");
        }
        this.classLoader = classLoader;
    }

    public String[] lookupParameterNames(AccessibleObject methodOrConstructor) {
        return this.lookupParameterNames(methodOrConstructor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] lookupParameterNames(AccessibleObject methodOrConstructor, boolean throwExceptionIfMissing) {
        try {
            JavaSourceFileMethodParametersParser parser = new JavaSourceFileMethodParametersParser();
            String javaSource = null;
            if (methodOrConstructor instanceof Method) {
                Method m = (Method)methodOrConstructor;
                javaSource = m.getDeclaringClass().getName().replace('.', '/') + ".java";
            } else {
                if (!(methodOrConstructor instanceof Constructor)) throw new IllegalArgumentException("unknow AccessibleObject" + methodOrConstructor + ",must be Method or Constructor");
                Constructor c = (Constructor)methodOrConstructor;
                javaSource = c.getDeclaringClass().getName().replace('.', '/') + ".java";
            }
            InputStream javaSourceInputStream = this.classLoader.getResourceAsStream(javaSource);
            try {
                if (javaSourceInputStream != null) {
                    String[] stringArray2 = parser.parseJavaFileForParamNames(methodOrConstructor, IOHelper.toString(javaSourceInputStream));
                    return stringArray2;
                }
                String[] stringArray = Paranamer.EMPTY_NAMES;
                return stringArray;
            }
            finally {
                if (javaSourceInputStream != null) {
                    javaSourceInputStream.close();
                }
            }
        }
        catch (IOException e) {
            if (!throwExceptionIfMissing) return Paranamer.EMPTY_NAMES;
            throw new RuntimeException("IOException while reading javasource,method:" + methodOrConstructor, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaSourceFileMethodParametersParser {
        public String[] parseJavaFileForParamNames(Constructor<?> constructor, String content) {
            return this.parseJavaFileForParamNames(content, constructor.getName(), constructor.getParameterTypes());
        }

        public String[] parseJavaFileForParamNames(Method method, String content) {
            return this.parseJavaFileForParamNames(content, method.getName(), method.getParameterTypes());
        }

        public String[] parseJavaFileForParamNames(AccessibleObject methodOrConstructor, String content) {
            if (methodOrConstructor instanceof Method) {
                return this.parseJavaFileForParamNames((Method)methodOrConstructor, content);
            }
            if (methodOrConstructor instanceof Constructor) {
                return this.parseJavaFileForParamNames((Constructor)methodOrConstructor, content);
            }
            throw new IllegalArgumentException("unknow AccessibleObject" + methodOrConstructor + ",must be Method or Constructor");
        }

        private String[] parseJavaFileForParamNames(String content, String name, Class<?>[] parameterTypes) {
            Pattern methodPattern = Pattern.compile("(?s)" + name + "\\s*\\(" + this.getParamsPattern(parameterTypes) + "\\)\\s*\\{");
            Matcher m = methodPattern.matcher(content);
            ArrayList<String> paramNames = new ArrayList<String>();
            if (m.find()) {
                for (int i = 1; i <= parameterTypes.length; ++i) {
                    paramNames.add(m.group(i));
                }
                return paramNames.toArray(new String[0]);
            }
            return null;
        }

        private String getParamsPattern(Class<?>[] parameterTypes) {
            ArrayList<String> paramPatterns = new ArrayList<String>();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> type = parameterTypes[i];
                String paramPattern = ".*" + type.getSimpleName() + ".*\\s+(\\w+).*";
                paramPatterns.add(paramPattern);
            }
            return StringHelper.join(paramPatterns, ",");
        }
    }
}

