/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.util.FileHelper;
import cn.org.rapid_framework.generator.util.IOHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    private static AtomicLong tempFileCount = new AtomicLong(System.currentTimeMillis());

    public static File unzip2TempDir(File zipfile, String tempRootFolderName) {
        try {
            File tempFolder = new File(System.getProperty("java.io.tmpdir"), tempRootFolderName + "/" + tempFileCount.incrementAndGet() + ".tmp");
            if (!tempFolder.mkdirs()) {
                throw new RuntimeException("cannot make temp folder:" + tempFolder);
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipfile));
            ZipUtils.unzip(tempFolder, in);
            ((InputStream)in).close();
            return tempFolder;
        }
        catch (IOException e) {
            throw new RuntimeException("cannot create temp folder", e);
        }
    }

    public static void unzip(File unzipDir, InputStream in) throws IOException {
        unzipDir.mkdirs();
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            File path = new File(unzipDir, entry.getName());
            if (entry.isDirectory()) {
                path.mkdirs();
                continue;
            }
            FileHelper.parentMkdir(path.getAbsolutePath());
            IOHelper.saveFile(path, zin);
        }
    }

    public static void unzip(File unzipDir, File zipFile) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipUtils.unzip(unzipDir, in);
        ((InputStream)in).close();
    }

    private static void makedirs(File f) {
        File ff = new File(f.getParent());
        if (!ff.exists()) {
            ff.mkdirs();
        }
    }
}

