/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.GeneratorConstants;
import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.provider.db.table.model.Column;
import cn.org.rapid_framework.generator.util.Inflector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    private static final Map<String, String> XML = new HashMap<String, String>();
    private static final Random RANDOM;
    static Pattern three;
    static Pattern two;

    public static String removeCrlf(String str) {
        if (str == null) {
            return null;
        }
        return StringHelper.join(StringHelper.tokenizeToStringArray(str, "\t\n\r\f"), " ");
    }

    public static String unescapeXml(String str) {
        if (str == null) {
            return null;
        }
        for (String key : XML.keySet()) {
            String value = XML.get(key);
            str = StringHelper.replace(str, "&" + key + ";", value);
        }
        return str;
    }

    public static String escapeXml(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String escapedStr = StringHelper.getEscapedStringByChar(c);
            if (escapedStr == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedStr);
        }
        return sb.toString();
    }

    public static String escapeXml(String str, String escapeChars) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (escapeChars.indexOf(c) < 0) {
                sb.append(c);
                continue;
            }
            String escapedStr = StringHelper.getEscapedStringByChar(c);
            if (escapedStr == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedStr);
        }
        return sb.toString();
    }

    private static String getEscapedStringByChar(char c) {
        String escapedStr = null;
        for (String key : XML.keySet()) {
            String value = XML.get(key);
            if (c != value.charAt(0)) continue;
            escapedStr = "&" + key + ";";
        }
        return escapedStr;
    }

    public static String removePrefix(String str, String prefix) {
        return StringHelper.removePrefix(str, prefix, false);
    }

    public static String removePrefix(String str, String prefix, boolean ignoreCase) {
        if (str == null) {
            return null;
        }
        if (prefix == null) {
            return str;
        }
        if (ignoreCase ? str.toLowerCase().startsWith(prefix.toLowerCase()) : str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !StringHelper.isBlank(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringHelper.isEmpty(str);
    }

    public static String getExtension(String str) {
        if (str == null) {
            return null;
        }
        int i = str.lastIndexOf(46);
        if (i >= 0) {
            return str.substring(i + 1);
        }
        return null;
    }

    public static String insertBefore(String content, String compareToken, String insertString) {
        if (content.indexOf(insertString) >= 0) {
            return content;
        }
        int index = content.indexOf(compareToken);
        if (index >= 0) {
            return new StringBuffer(content).insert(index, insertString).toString();
        }
        throw new IllegalArgumentException("not found insert location by compareToken:" + compareToken + " content:" + content);
    }

    public static String insertAfter(String content, String compareToken, String insertString) {
        if (content.indexOf(insertString) >= 0) {
            return content;
        }
        int index = content.indexOf(compareToken);
        if (index >= 0) {
            return new StringBuffer(content).insert(index + compareToken.length(), insertString).toString();
        }
        throw new IllegalArgumentException("not found insert location by compareToken:" + compareToken + " content:" + content);
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static boolean contains(String str, String ... keywords) {
        if (str == null) {
            return false;
        }
        if (keywords == null) {
            throw new IllegalArgumentException("'keywords' must be not null");
        }
        for (String keyword : keywords) {
            if (!str.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String defaultString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String defaultIfEmpty(Object value, String defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value.toString();
    }

    public static String makeAllWordFirstLetterUpperCase(String sqlName) {
        String[] strs = sqlName.toLowerCase().split("_");
        String result = "";
        String preStr = "";
        for (int i = 0; i < strs.length; ++i) {
            result = preStr.length() == 1 ? result + strs[i] : result + StringHelper.capitalize(strs[i]);
            preStr = strs[i];
        }
        return result;
    }

    public static int indexOfByRegex(String input, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }

    public static String toJavaVariableName(String str) {
        return StringHelper.uncapitalize(StringHelper.toJavaClassName(str));
    }

    public static String toJavaClassName(String sqlName) {
        String processedSqlName = StringHelper.removeTableSqlNamePrefix(sqlName);
        if (GeneratorProperties.getBoolean(GeneratorConstants.TABLE_NAME_SINGULARIZE)) {
            processedSqlName = StringHelper.singularize(processedSqlName);
        }
        return StringHelper.makeAllWordFirstLetterUpperCase(StringHelper.toUnderscoreName(processedSqlName));
    }

    public static String removeTableSqlNamePrefix(String sqlName) {
        String[] prefixs;
        for (String prefix : prefixs = GeneratorProperties.getStringArray(GeneratorConstants.TABLE_REMOVE_PREFIXES)) {
            String removedPrefixSqlName = StringHelper.removePrefix(sqlName, prefix, true);
            if (removedPrefixSqlName.equals(sqlName)) continue;
            return removedPrefixSqlName;
        }
        return sqlName;
    }

    public static String getJavaClassSimpleName(String clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.lastIndexOf(".") >= 0) {
            return clazz.substring(clazz.lastIndexOf(".") + 1);
        }
        return clazz;
    }

    public static String removeMany(String inString, String ... keywords) {
        if (inString == null) {
            return null;
        }
        for (String k : keywords) {
            inString = StringHelper.replace(inString, k, "");
        }
        return inString;
    }

    public static void appendReplacement(Matcher m, StringBuffer sb, String replacement) {
        replacement = StringHelper.replace(replacement, "$", "\\$");
        m.appendReplacement(sb, replacement);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static String capitalize(String str) {
        return StringHelper.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringHelper.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static String randomNumeric(int count) {
        return StringHelper.random(count, false, true);
    }

    public static String random(int count, boolean letters, boolean numbers) {
        return StringHelper.random(count, 0, 0, letters, numbers);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return StringHelper.random(count, start, end, letters, numbers, null, RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    public static String toUnderscoreName(String name) {
        if (name == null) {
            return null;
        }
        String filteredName = name;
        if (filteredName.indexOf("_") >= 0 && filteredName.equals(filteredName.toUpperCase())) {
            filteredName = filteredName.toLowerCase();
        }
        if (filteredName.indexOf("_") == -1 && filteredName.equals(filteredName.toUpperCase())) {
            filteredName = filteredName.toLowerCase();
        }
        StringBuffer result = new StringBuffer();
        if (filteredName != null && filteredName.length() > 0) {
            result.append(filteredName.substring(0, 1).toLowerCase());
            for (int i = 1; i < filteredName.length(); ++i) {
                String preChart = filteredName.substring(i - 1, i);
                String c = filteredName.substring(i, i + 1);
                if (c.equals("_")) {
                    result.append("_");
                    continue;
                }
                if (preChart.equals("_")) {
                    result.append(c.toLowerCase());
                    continue;
                }
                if (c.matches("\\d")) {
                    result.append(c);
                    continue;
                }
                if (c.equals(c.toUpperCase())) {
                    result.append("_");
                    result.append(c.toLowerCase());
                    continue;
                }
                result.append(c);
            }
        }
        return result.toString();
    }

    public static String removeEndWiths(String inputString, String ... endWiths) {
        for (String endWith : endWiths) {
            if (!inputString.endsWith(endWith)) continue;
            return inputString.substring(0, inputString.length() - endWith.length());
        }
        return inputString;
    }

    public static List<Column.EnumMetaDada> string2EnumMetaData(String data) {
        if (data == null || data.trim().length() == 0) {
            return new ArrayList<Column.EnumMetaDada>();
        }
        ArrayList<Column.EnumMetaDada> list = new ArrayList<Column.EnumMetaDada>();
        Pattern p = Pattern.compile("\\w+\\(.*?\\)");
        Matcher m = p.matcher(data);
        while (m.find()) {
            String str = m.group();
            Matcher three_m = three.matcher(str);
            if (three_m.find()) {
                list.add(new Column.EnumMetaDada(three_m.group(1), three_m.group(2), three_m.group(3)));
                continue;
            }
            Matcher two_m = two.matcher(str);
            if (two_m.find()) {
                list.add(new Column.EnumMetaDada(two_m.group(1), two_m.group(1), two_m.group(2)));
                continue;
            }
            throw new IllegalArgumentException("error enumString format:" + data + " expected format:F(1,Female);M(0,Male) or F(Female);M(Male)");
        }
        return list;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static String[] tokenizeToStringArray(String str, String seperators) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tokenlizer = new StringTokenizer(str, seperators);
        ArrayList<Object> result = new ArrayList<Object>();
        while (tokenlizer.hasMoreElements()) {
            Object s = tokenlizer.nextElement();
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String join(List list, String seperator) {
        return StringHelper.join(list.toArray(new Object[0]), seperator);
    }

    public static String replace(int start, int end, String str, String replacement) {
        String before = str.substring(0, start);
        String after = str.substring(end);
        return before + replacement + after;
    }

    public static String join(Object[] array, String seperator) {
        if (array == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i]);
            if (i == array.length - 1) continue;
            result.append(seperator);
        }
        return result.toString();
    }

    public static int containsCount(String string, String keyword) {
        int indexOf;
        if (string == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < string.length() && (indexOf = string.indexOf(keyword, i)) >= 0; ++i) {
            ++count;
            i = indexOf;
        }
        return count;
    }

    public static String getByRegex(String str, String regex) {
        return StringHelper.getByRegex(str, regex, 0);
    }

    public static String getByRegex(String str, String regex, int group) {
        if (regex == null) {
            throw new NullPointerException();
        }
        if (group < 0) {
            throw new IllegalArgumentException();
        }
        if (str == null) {
            return null;
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        if (m.find()) {
            return m.group(group);
        }
        return null;
    }

    public static String removeIbatisOrderBy(String sql) {
        String orderByRemovedSql = sql.replaceAll("(?si)<\\w+[^>]*?>\\s*order\\s+by\\s+[^<]+?</\\w+>", "").replaceAll("(?i)<\\w+[\\w\\s='\"]+prepend[\\w\\s='\"]*?order\\s+by\\s*['\"][^>]*?>[^<]+</\\w+>", "").replaceAll("(?i)\\s*order\\s+by\\s+.*", "");
        return StringHelper.removeXmlTagIfBodyEmpty(StringHelper.removeXmlTagIfBodyEmpty(StringHelper.removeXmlTagIfBodyEmpty(StringHelper.removeXmlTagIfBodyEmpty(orderByRemovedSql))));
    }

    public static String removeXMLCdataTag(String str) {
        if (str == null) {
            return null;
        }
        str = StringHelper.replace(str, "<![CDATA[", "");
        str = StringHelper.replace(str, "]]>", "");
        return str;
    }

    public static String insertTokenIntoSelectSql(String str, String insertValue) {
        String token = "select\\s";
        int selectBeginPos = StringHelper.indexOfByRegex(str, "(?si)" + token);
        if (selectBeginPos == -1) {
            return str;
        }
        return new StringBuffer(str).insert(selectBeginPos + "select ".length(), insertValue).toString();
    }

    public static String removeXmlTagIfBodyEmpty(String sql) {
        return sql.replaceAll("<\\w+[^>]*?>\\s+</\\w+>", "");
    }

    public static String columnNameToClassName(String dbName) {
        throw new UnsupportedOperationException();
    }

    public static String tableNameToClassName(String dbName) {
        return StringHelper.makeAllWordFirstLetterUpperCase(StringHelper.toUnderscoreName(dbName));
    }

    public static String pluralize(String word) {
        return Inflector.getInstance().pluralize(word);
    }

    public static String singularize(String word) {
        return Inflector.getInstance().singularize(word);
    }

    static {
        XML.put("apos", "'");
        XML.put("quot", "\"");
        XML.put("amp", "&");
        XML.put("lt", "<");
        XML.put("gt", ">");
        RANDOM = new Random();
        three = Pattern.compile("(.*)\\((.*),(.*)\\)");
        two = Pattern.compile("(.*)\\((.*)\\)");
    }
}

