/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.util.DBHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExecutorHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map> queryForList(Connection conn, String sql, int limit) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql.trim());
        ps.setMaxRows(limit);
        ps.setFetchDirection(1000);
        ResultSet rs = ps.executeQuery();
        try {
            List<Map> result;
            List<Map> list = result = SqlExecutorHelper.toListMap(limit, rs);
            return list;
        }
        finally {
            DBHelper.close(rs);
        }
    }

    public static boolean execute(DataSource ds, String sql) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            Statement s = conn.createStatement();
            boolean bl = s.execute(sql);
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage() + " errorCode:" + e.getErrorCode() + " SQLState:" + e.getSQLState());
        }
        finally {
            DBHelper.close(conn);
        }
    }

    public static List<Map> toListMap(int limit, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = 0;
        ArrayList<Map> list = new ArrayList<Map>();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                row.put(rsmd.getColumnName(i), rs.getObject(i));
            }
            list.add(row);
            if (++count < limit) continue;
            break;
        }
        return list;
    }
}

