/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.util.ClassHelper;
import cn.org.rapid_framework.generator.util.FileHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesHelper {
    boolean isSearchSystemProperty = false;
    Properties p;

    public PropertiesHelper(Properties p) {
        this.p = p;
    }

    public PropertiesHelper(Properties p, boolean isSearchSystemProperty) {
        this.p = p;
        this.isSearchSystemProperty = isSearchSystemProperty;
    }

    public Properties getProperties() {
        return this.p;
    }

    public String getProperty(String key, String defaultValue) {
        String value = null;
        if (this.isSearchSystemProperty) {
            value = System.getProperty(key);
        }
        if (value == null || "".equals(value.trim())) {
            value = this.getProperties().getProperty(key);
        }
        return value == null || "".equals(value.trim()) ? defaultValue : value;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getRequiredProperty(String key) {
        String value = this.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            throw new IllegalStateException("required property is blank by key=" + key);
        }
        return value;
    }

    public Integer getInt(String key) {
        if (this.getProperty(key) == null) {
            return null;
        }
        return Integer.parseInt(this.getRequiredProperty(key));
    }

    public int getInt(String key, int defaultValue) {
        if (this.getProperty(key) == null) {
            return defaultValue;
        }
        return Integer.parseInt(this.getRequiredProperty(key));
    }

    public int getRequiredInt(String key) {
        return Integer.parseInt(this.getRequiredProperty(key));
    }

    public String[] getStringArray(String key) {
        String v = this.getProperty(key);
        if (v == null) {
            return new String[0];
        }
        return StringHelper.tokenizeToStringArray(v, ", \t\n\r\f");
    }

    public int[] getIntArray(String key) {
        String[] array = this.getStringArray(key);
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Integer.parseInt(array[i]);
        }
        return result;
    }

    public Boolean getBoolean(String key) {
        if (this.getProperty(key) == null) {
            return null;
        }
        return Boolean.parseBoolean(this.getRequiredProperty(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.getProperty(key) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.getRequiredProperty(key));
    }

    public boolean getRequiredBoolean(String key) {
        return Boolean.parseBoolean(this.getRequiredProperty(key));
    }

    public String getNullIfBlank(String key) {
        String value = this.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        return value;
    }

    public PropertiesHelper setProperty(String key, String value) {
        this.p.setProperty(key, value);
        return this;
    }

    public void clear() {
        this.p.clear();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.p.entrySet();
    }

    public Enumeration<?> propertyNames() {
        return this.p.propertyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String ... files) throws InvalidPropertiesFormatException, IOException {
        Properties properties = new Properties();
        for (String f : files) {
            File file = FileHelper.getFile(f);
            FileInputStream input = new FileInputStream(file);
            try {
                if (file.getPath().endsWith(".xml")) {
                    properties.loadFromXML(input);
                } else {
                    properties.load(input);
                }
                properties.putAll((Map<?, ?>)properties);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] loadAllPropertiesFromClassLoader(Properties properties, String ... resourceNames) throws IOException {
        ArrayList<String> successLoadProperties = new ArrayList<String>();
        for (String resourceName : resourceNames) {
            Enumeration<URL> urls = ClassHelper.getDefaultClassLoader().getResources(resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                successLoadProperties.add(url.getFile());
                InputStream input = null;
                try {
                    URLConnection con = url.openConnection();
                    con.setUseCaches(false);
                    input = con.getInputStream();
                    if (resourceName.endsWith(".xml")) {
                        properties.loadFromXML(input);
                        continue;
                    }
                    properties.load(input);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
        }
        return successLoadProperties.toArray(new String[0]);
    }
}

