/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOHelper {
    public static Writer NULL_WRITER = new NullWriter();

    public static void copy(Reader reader, Writer writer) {
        char[] buf = new char[8192];
        int n = 0;
        try {
            while ((n = reader.read(buf)) != -1) {
                writer.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(InputStream in, OutputStream out) {
        try {
            byte[] buf = new byte[8192];
            int n = 0;
            while ((n = in.read(buf)) != -1) {
                out.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readLines(Reader input) {
        try {
            BufferedReader reader = new BufferedReader(input);
            ArrayList<String> list = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFile(File file) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String result = IOHelper.toString(in);
            ((Reader)in).close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("occer IOException when read file:" + file, e);
        }
    }

    public static String toString(Reader in) {
        StringWriter out = new StringWriter();
        IOHelper.copy(in, out);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) {
        String string;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            string = IOHelper.toString(encoding, inputStream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }

    public static String toString(InputStream inputStream) {
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringWriter writer = new StringWriter();
        IOHelper.copy(reader, writer);
        return writer.toString();
    }

    public static String toString(String encoding, InputStream inputStream) {
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, encoding);
            StringWriter writer = new StringWriter();
            IOHelper.copy(reader, writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(File file, String content) {
        IOHelper.saveFile(file, content, null, false);
    }

    public static void saveFile(File file, String content, boolean append) {
        IOHelper.saveFile(file, content, null, append);
    }

    public static void saveFile(File file, String content, String encoding) {
        IOHelper.saveFile(file, content, encoding, false);
    }

    public static void saveFile(File file, String content, String encoding, boolean append) {
        try {
            FileOutputStream output = new FileOutputStream(file, append);
            OutputStreamWriter writer = StringHelper.isBlank(encoding) ? new OutputStreamWriter(output) : new OutputStreamWriter((OutputStream)output, encoding);
            writer.write(content);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(File file, InputStream in) {
        try {
            FileOutputStream output = new FileOutputStream(file);
            IOHelper.copy(in, output);
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndClose(InputStream in, OutputStream out) {
        try {
            IOHelper.copy(in, out);
        }
        finally {
            IOHelper.close(in, out);
        }
    }

    public static void close(InputStream in, OutputStream out) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }
    }
}

