/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.util.ClassHelper;
import cn.org.rapid_framework.generator.util.IOHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHelper {
    public static List ignoreList = new ArrayList();
    public static Set binaryExtentionsList;

    public static String getRelativePath(File baseDir, File file) {
        if (baseDir.equals(file)) {
            return "";
        }
        if (baseDir.getParentFile() == null) {
            return file.getAbsolutePath().substring(baseDir.getAbsolutePath().length());
        }
        return file.getAbsolutePath().substring(baseDir.getAbsolutePath().length() + 1);
    }

    public static List<File> searchAllNotIgnoreFile(File dir) {
        ArrayList<File> arrayList = new ArrayList<File>();
        FileHelper.searchAllNotIgnoreFile(dir, arrayList);
        Collections.sort(arrayList, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        return arrayList;
    }

    public static File getFile(String file) {
        if (StringHelper.isBlank(file)) {
            throw new IllegalArgumentException("'file' must be not blank");
        }
        try {
            if (file.startsWith("classpath:")) {
                return FileHelper.getFileByClassLoader(file.substring("classpath:".length()));
            }
            return new File(FileHelper.toFilePathIfIsURL(new File(file)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("getFile() error,file:" + file, e);
        }
    }

    public static InputStream getInputStream(String file) throws FileNotFoundException {
        InputStream inputStream = null;
        inputStream = file.startsWith("classpath:") ? ClassHelper.getDefaultClassLoader().getResourceAsStream(file.substring("classpath:".length())) : new FileInputStream(file);
        return inputStream;
    }

    public static void searchAllNotIgnoreFile(File dir, List<File> collector) {
        collector.add(dir);
        if (!dir.isHidden() && dir.isDirectory() && !FileHelper.isIgnoreFile(dir)) {
            File[] subFiles = dir.listFiles();
            for (int i = 0; i < subFiles.length; ++i) {
                FileHelper.searchAllNotIgnoreFile(subFiles[i], collector);
            }
        }
    }

    public static String readEntireDirectoryContent(File dir, String encoding) {
        List<File> files = FileHelper.searchAllNotIgnoreFile(dir);
        StringBuffer result = new StringBuffer();
        for (File file : files) {
            if (file.isDirectory() || !file.isFile() || !file.exists()) continue;
            result.append(IOHelper.readFile(file, encoding));
        }
        return result.toString();
    }

    public static File mkdir(String dir, String file) {
        if (dir == null) {
            throw new IllegalArgumentException("dir must be not null");
        }
        File result = new File(dir, file);
        FileHelper.parnetMkdir(result);
        return result;
    }

    public static File parentMkdir(String file) {
        if (file == null) {
            throw new IllegalArgumentException("file must be not null");
        }
        File result = new File(file);
        FileHelper.parnetMkdir(result);
        return result;
    }

    public static void parnetMkdir(File outputFile) {
        File parentFile = outputFile.getParentFile();
        if (parentFile != null && !parentFile.equals(outputFile)) {
            parentFile.mkdirs();
        }
    }

    public static File getFileByClassLoader(String resourceName) throws IOException {
        Enumeration<URL> urls = ClassHelper.getDefaultClassLoader().getResources(resourceName);
        if (urls.hasMoreElements()) {
            return new File(urls.nextElement().getFile());
        }
        urls = FileHelper.class.getClassLoader().getResources(resourceName);
        if (urls.hasMoreElements()) {
            return new File(urls.nextElement().getFile());
        }
        urls = ClassLoader.getSystemResources(resourceName);
        if (urls.hasMoreElements()) {
            return new File(urls.nextElement().getFile());
        }
        throw new FileNotFoundException("classpath:" + resourceName);
    }

    private static boolean isIgnoreFile(File file) {
        for (int i = 0; i < ignoreList.size(); ++i) {
            if (!file.getName().equals(ignoreList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void loadBinaryExtentionsList(String resourceName, boolean ignoreException) {
        block4: {
            try {
                Enumeration<URL> urls = FileHelper.class.getClassLoader().getResources(resourceName);
                boolean notFound = true;
                while (urls.hasMoreElements()) {
                    notFound = false;
                    URL url = urls.nextElement();
                    InputStream input = url.openStream();
                    binaryExtentionsList.addAll(IOHelper.readLines(new InputStreamReader(input)));
                    input.close();
                }
                if (notFound) {
                    throw new IllegalStateException("not found required file with:" + resourceName);
                }
            }
            catch (Exception e) {
                if (ignoreException) break block4;
                throw new RuntimeException("loadBinaryExtentionsList occer error,resourceName:" + resourceName, e);
            }
        }
    }

    public static boolean isBinaryFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return FileHelper.isBinaryFile(file.getName());
    }

    public static boolean isBinaryFile(String filename) {
        if (StringHelper.isBlank(FileHelper.getExtension(filename))) {
            return false;
        }
        return binaryExtentionsList.contains(FileHelper.getExtension(filename).toLowerCase());
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.indexOf(".");
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileHelper.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileHelper.cleanDirectory(file);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileHelper.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileHelper.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                throw new IOException("Unable to delete file: " + file);
            }
        }
    }

    public static String toFilePathIfIsURL(File file) {
        try {
            return new URL(file.getPath()).getPath();
        }
        catch (MalformedURLException e) {
            return file.getPath();
        }
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    static {
        ignoreList.add(".svn");
        ignoreList.add("CVS");
        ignoreList.add(".cvsignore");
        ignoreList.add(".copyarea.db");
        ignoreList.add("SCCS");
        ignoreList.add("vssver.scc");
        ignoreList.add(".DS_Store");
        ignoreList.add(".git");
        ignoreList.add(".gitignore");
        binaryExtentionsList = new HashSet();
        FileHelper.loadBinaryExtentionsList("binary_filelist.txt", true);
        FileHelper.loadBinaryExtentionsList("cn/org/rapid_framework/generator/util/binary_filelist.txt", false);
    }
}

