/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.util;

import cn.org.rapid_framework.generator.util.DateHelper;
import cn.org.rapid_framework.generator.util.GLogger;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanHelper {
    public static Map describe(Object obj, String ... ignoreProperties) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PropertyDescriptor[] descriptors = BeanHelper.getPropertyDescriptors(obj.getClass());
        for (int i = 0; i < descriptors.length; ++i) {
            Method readMethod;
            String name = descriptors[i].getName();
            if (BeanHelper.contains(ignoreProperties, name) || (readMethod = descriptors[i].getReadMethod()) == null) continue;
            try {
                long start = System.currentTimeMillis();
                map.put(name, readMethod.invoke(obj, new Object[0]));
                long cost = start - System.currentTimeMillis();
                continue;
            }
            catch (Exception e) {
                GLogger.warn("error get property value,name:" + name + " on bean:" + obj, e);
            }
        }
        return map;
    }

    private static boolean contains(String[] array, String str) {
        if (array == null) {
            return false;
        }
        if (str == null) {
            return false;
        }
        for (String ignore : array) {
            if (!str.equals(ignore)) continue;
            return true;
        }
        return false;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName, boolean ignoreCase) {
        for (PropertyDescriptor pd : BeanHelper.getPropertyDescriptors(beanClass)) {
            if (!(ignoreCase ? pd.getName().equalsIgnoreCase(propertyName) : pd.getName().equals(propertyName))) continue;
            return pd;
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public static void copyProperties(Object target, Object source) {
        BeanHelper.copyProperties(target, source, false);
    }

    public static void copyProperties(Object target, Object source, boolean ignoreCase) {
        BeanHelper.copyProperties(target, source, ignoreCase, null);
    }

    public static void copyProperties(Object target, Map source) {
        BeanHelper.copyProperties(target, source, false);
    }

    public static void copyProperties(Object target, Map source, boolean ignoreCase) {
        Set keys = source.keySet();
        for (String key : keys) {
            PropertyDescriptor pd = BeanHelper.getPropertyDescriptor(target.getClass(), key, ignoreCase);
            if (pd == null) {
                throw new IllegalArgumentException("not found property:'" + key + "' on class:" + target.getClass());
            }
            BeanHelper.setProperty(target, pd, source.get(key));
        }
    }

    public static void copyProperties(Object target, Object source, boolean ignoreCase, String[] ignoreProperties) {
        if (target instanceof Map) {
            throw new UnsupportedOperationException("target is Map unsuported");
        }
        PropertyDescriptor[] targetPds = BeanHelper.getPropertyDescriptors(target.getClass());
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (int i = 0; i < targetPds.length; ++i) {
            PropertyDescriptor targetPd = targetPds[i];
            if (targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName())) continue;
            try {
                Object value;
                if (source instanceof Map) {
                    Map map = (Map)source;
                    if (!MapHelper.containsKey(map, targetPd.getName(), ignoreCase)) continue;
                    value = MapHelper.getValue(map, targetPd.getName(), ignoreCase);
                    BeanHelper.setProperty(target, targetPd, value);
                    continue;
                }
                PropertyDescriptor sourcePd = BeanHelper.getPropertyDescriptor(source.getClass(), targetPd.getName(), ignoreCase);
                if (sourcePd == null || sourcePd.getReadMethod() == null) continue;
                value = BeanHelper.getProperty(source, sourcePd);
                BeanHelper.setProperty(target, targetPd, value);
                continue;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not copy properties on:" + targetPd.getDisplayName(), ex);
            }
        }
    }

    private static Object getProperty(Object source, PropertyDescriptor sourcePd) throws IllegalAccessException, InvocationTargetException {
        Method readMethod = sourcePd.getReadMethod();
        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
            readMethod.setAccessible(true);
        }
        Object value = readMethod.invoke(source, new Object[0]);
        return value;
    }

    public static void setProperty(Object target, String propertyName, Object value) {
        PropertyDescriptor pd = BeanHelper.getPropertyDescriptor(target.getClass(), propertyName, false);
        if (pd == null) {
            throw new IllegalArgumentException("not found property:" + propertyName + " on class:" + target.getClass());
        }
        BeanHelper.setProperty(target, pd, value);
    }

    public static void setProperty(Object target, String propertyName, Object value, boolean ignoreCase) {
        PropertyDescriptor pd = BeanHelper.getPropertyDescriptor(target.getClass(), propertyName, ignoreCase);
        if (pd == null) {
            throw new IllegalArgumentException("not found property:" + propertyName + " on class:" + target.getClass());
        }
        BeanHelper.setProperty(target, pd, value);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setProperty(Object target, PropertyDescriptor propertyDescriptor, Object value) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("propertyDescriptor must be not null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target must be not null");
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalArgumentException("not found write method for property:" + propertyDescriptor.getName() + " on class:" + target.getClass());
        }
        if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
            writeMethod.setAccessible(true);
        }
        try {
            writeMethod.invoke(target, BeanHelper.convert(value, writeMethod.getParameterTypes()[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("error set property:" + propertyDescriptor.getName() + " on class:" + target.getClass(), e);
        }
    }

    private static Object convert(Object value, Class<?> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType == String.class) {
            return value.toString();
        }
        return BeanHelper.convert(value.toString(), targetType);
    }

    private static Object convert(String value, Class<?> targetType) {
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return new Byte(value);
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return new Short(value);
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return new Integer(value);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return new Long(value);
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return new Float(value);
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return new Double(value);
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (targetType == BigInteger.class) {
            return BigInteger.valueOf(Long.parseLong(value));
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return new Boolean(value);
        }
        if (targetType == Boolean.TYPE) {
            return new Boolean(value);
        }
        if (targetType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (DateHelper.isDateType(targetType)) {
            return DateHelper.parseDate(value, targetType, "yyyyMMdd", "yyyy-MM-dd", "yyyyMMddHHmmSS", "yyyy-MM-dd HH:mm:ss", "HH:mm:ss");
        }
        throw new IllegalArgumentException("cannot convert value:" + value + " to targetType:" + targetType);
    }

    static class MapHelper {
        MapHelper() {
        }

        public static Object getValue(Map map, String property, boolean ignoreCase) {
            if (ignoreCase) {
                for (Object key : map.keySet()) {
                    if (!property.equalsIgnoreCase(key.toString())) continue;
                    return map.get(key);
                }
                return null;
            }
            return map.get(property);
        }

        public static boolean containsKey(Map map, String property, boolean ignoreCase) {
            if (ignoreCase) {
                for (Object key : map.keySet()) {
                    if (!property.equalsIgnoreCase(key.toString())) continue;
                    return true;
                }
                return false;
            }
            return map.containsKey(property);
        }
    }
}

