/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.java.model;

import cn.org.rapid_framework.generator.provider.java.model.JavaClass;
import cn.org.rapid_framework.generator.util.typemapping.ActionScriptDataTypesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class JavaField {
    private Field field;
    private JavaClass clazz;

    public JavaField(Field field, JavaClass clazz) {
        this.field = field;
        this.clazz = clazz;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public JavaClass getType() {
        return new JavaClass(this.field.getType());
    }

    public boolean isAccessible() {
        return this.field.isAccessible();
    }

    public boolean isEnumConstant() {
        return this.field.isEnumConstant();
    }

    public String toGenericString() {
        return this.field.toGenericString();
    }

    public JavaClass getClazz() {
        return this.clazz;
    }

    public String getJavaType() {
        return this.field.getType().getName();
    }

    public String getAsType() {
        return ActionScriptDataTypesUtils.getPreferredAsType(this.getJavaType());
    }

    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public boolean getIsDateTimeField() {
        return this.getJavaType().equalsIgnoreCase("java.util.Date") || this.getJavaType().equalsIgnoreCase("java.sql.Date") || this.getJavaType().equalsIgnoreCase("java.sql.Timestamp") || this.getJavaType().equalsIgnoreCase("java.sql.Time");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaField other = (JavaField)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }

    public String toString() {
        return "JavaClass:" + this.clazz + " JavaField:" + this.getFieldName();
    }
}

