/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.java.model;

import cn.org.rapid_framework.generator.provider.java.model.JavaField;
import cn.org.rapid_framework.generator.provider.java.model.JavaMethod;
import cn.org.rapid_framework.generator.provider.java.model.JavaProperty;
import cn.org.rapid_framework.generator.util.IOHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.typemapping.ActionScriptDataTypesUtils;
import cn.org.rapid_framework.generator.util.typemapping.JavaImport;
import cn.org.rapid_framework.generator.util.typemapping.JavaPrimitiveTypeMapping;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass {
    private Class clazz;
    private String mavenJavaSourceFileContent;

    public JavaClass(Class clazz) {
        this.clazz = clazz;
    }

    public String getClassName() {
        return JavaClass.getClassName(this.getSimpleJavaType());
    }

    static String getClassName(String simpleJavaType) {
        return simpleJavaType.indexOf(36) >= 0 ? simpleJavaType.substring(simpleJavaType.indexOf(36) + 1) : simpleJavaType;
    }

    public String getPackageName() {
        return this.clazz.getPackage().getName();
    }

    public String getLastPackageName() {
        return StringHelper.getExtension(this.getPackageName());
    }

    public String getLastPackageNameFirstUpper() {
        return this.getLastPackageName() == null ? "" : StringHelper.capitalize(this.getLastPackageName());
    }

    public boolean isHasDefaultConstructor() {
        if (this.clazz.isInterface() || this.clazz.isAnnotation() || this.clazz.isEnum() || Modifier.isAbstract(this.clazz.getModifiers())) {
            return false;
        }
        for (Constructor<?> c : this.clazz.getConstructors()) {
            if (!Modifier.isPublic(c.getModifiers()) || c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public Set<JavaClass> getImportClasses() {
        Class[] clazzes;
        LinkedHashSet<JavaClass> set = new LinkedHashSet<JavaClass>();
        for (Method method : this.clazz.getMethods()) {
            clazzes = new Class[]{method.getReturnType()};
            JavaImport.addImportClass(set, clazzes);
            JavaImport.addImportClass(set, method.getParameterTypes());
            JavaImport.addImportClass(set, method.getExceptionTypes());
        }
        if (this.clazz.isMemberClass()) {
            Class[] clazzes2 = new Class[]{this.clazz};
            JavaImport.addImportClass(set, clazzes2);
        }
        for (AccessibleObject accessibleObject : this.clazz.getFields()) {
            clazzes = new Class[]{((Field)accessibleObject).getType()};
            JavaImport.addImportClass(set, clazzes);
        }
        for (AccessibleObject accessibleObject : this.clazz.getDeclaredFields()) {
            clazzes = new Class[]{((Field)accessibleObject).getType()};
            JavaImport.addImportClass(set, clazzes);
        }
        for (AccessibleObject accessibleObject : this.clazz.getDeclaredConstructors()) {
            JavaImport.addImportClass(set, ((Constructor)accessibleObject).getExceptionTypes());
            JavaImport.addImportClass(set, ((Constructor)accessibleObject).getParameterTypes());
        }
        for (AccessibleObject accessibleObject : this.clazz.getConstructors()) {
            JavaImport.addImportClass(set, ((Constructor)accessibleObject).getExceptionTypes());
            JavaImport.addImportClass(set, ((Constructor)accessibleObject).getParameterTypes());
        }
        for (AnnotatedElement annotatedElement : this.clazz.getDeclaredClasses()) {
            JavaImport.addImportClass(set, new Class[]{annotatedElement});
        }
        return set;
    }

    public Set<JavaClass> getPropertiesImportClasses() throws Exception {
        Set<JavaClass> set = this.getImportClasses();
        for (JavaProperty prop : this.getProperties()) {
            set.addAll(prop.getPropertyType().getImportClasses());
        }
        return set;
    }

    public String getSuperclassName() {
        return this.clazz.getSuperclass() != null ? this.clazz.getSuperclass().getName() : null;
    }

    public JavaMethod[] getMethods() {
        return this.toJavaMethods(this.clazz.getDeclaredMethods());
    }

    public JavaMethod getMethod(String methodName) {
        for (Method m : this.clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return new JavaMethod(m, this);
        }
        return null;
    }

    public JavaMethod[] getPublicMethods() {
        Method[] methods = this.clazz.getDeclaredMethods();
        return this.toJavaMethods(this.filterByModifiers(methods, 1));
    }

    public JavaMethod[] getPublicStaticMethods() {
        Method[] methods = this.clazz.getDeclaredMethods();
        return this.toJavaMethods(this.filterByModifiers(methods, 1, 8));
    }

    public JavaMethod[] getPublicNotStaticMethods() {
        Method[] staticMethods = this.filterByModifiers(this.clazz.getDeclaredMethods(), 8);
        Method[] publicMethods = this.filterByModifiers(this.clazz.getDeclaredMethods(), 1);
        Method[] filtered = this.exclude(publicMethods, staticMethods).toArray(new Method[0]);
        return this.toJavaMethods(filtered);
    }

    public JavaProperty[] getReadProperties() throws Exception {
        ArrayList<JavaProperty> result = new ArrayList<JavaProperty>();
        for (JavaProperty p : this.getProperties()) {
            if (!p.isHasReadMethod()) continue;
            result.add(p);
        }
        return result.toArray(new JavaProperty[0]);
    }

    public JavaProperty[] getWriteProperties() throws Exception {
        ArrayList<JavaProperty> result = new ArrayList<JavaProperty>();
        for (JavaProperty p : this.getProperties()) {
            if (!p.isHasWriteMethod()) continue;
            result.add(p);
        }
        return result.toArray(new JavaProperty[0]);
    }

    public JavaProperty[] getProperties() throws Exception {
        PropertyDescriptor[] pds;
        ArrayList<JavaProperty> result = new ArrayList<JavaProperty>();
        BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            if ("class".equalsIgnoreCase(pd.getName())) continue;
            result.add(new JavaProperty(pd, this));
        }
        return result.toArray(new JavaProperty[0]);
    }

    public List<JavaField> getFields() {
        Field[] fields = this.clazz.getDeclaredFields();
        ArrayList<JavaField> result = new ArrayList<JavaField>();
        for (Field f : fields) {
            result.add(new JavaField(f, this));
        }
        return result;
    }

    public String getPackagePath() {
        return this.getPackageName().replace(".", "/");
    }

    public String getParentPackageName() {
        return this.getPackageName().substring(0, this.getPackageName().lastIndexOf("."));
    }

    public String getParentPackagePath() {
        return this.getParentPackageName().replace(".", "/");
    }

    public String getClassFile() {
        return this.clazz.getClassLoader().getResource(this.clazz.getName().replace('.', '/') + ".class").getFile();
    }

    public String getJavaSourceFile() {
        return this.clazz.getName().replace('.', '/') + ".java";
    }

    public String getMavenJavaTestSourceFile() {
        return MavenHelper.getMavenJavaTestSourceFile(this.getClassFile());
    }

    public String getMavenJavaSourceFile() {
        return MavenHelper.getMavenJavaSourceFile(this.getClassFile());
    }

    public String getMavenJavaSourceFileContent() {
        File file;
        if (this.mavenJavaSourceFileContent == null && this.getMavenJavaSourceFile() != null && (file = new File(this.getMavenJavaSourceFile())).exists()) {
            this.mavenJavaSourceFileContent = IOHelper.readFile(file);
        }
        return this.mavenJavaSourceFileContent;
    }

    public String getLoadedClasspath() {
        return this.getClassFile().substring(0, this.getClassFile().length() - (this.clazz.getName() + ".class").length());
    }

    public String getAsType() {
        return ActionScriptDataTypesUtils.getPreferredAsType(this.getJavaType());
    }

    public String getJavaType() {
        if (this.isArray()) {
            return this.clazz.getComponentType().getName().replace("$", ".");
        }
        return this.clazz.getName().replace("$", ".");
    }

    public String getPrimitiveJavaType() {
        return JavaPrimitiveTypeMapping.getPrimitiveType(this.getJavaType());
    }

    public String getSimpleJavaType() {
        if (this.isArray()) {
            return this.clazz.getComponentType().getSimpleName();
        }
        return this.clazz.getSimpleName();
    }

    public String getNullValue() {
        return JavaPrimitiveTypeMapping.getDefaultValue(this.getJavaType());
    }

    public String getCanonicalName() {
        return this.clazz.getCanonicalName();
    }

    public JavaField getField(String name) throws NoSuchFieldException, SecurityException {
        return new JavaField(this.clazz.getDeclaredField(name), this);
    }

    public JavaClass getSuperclass() {
        return new JavaClass(this.clazz.getSuperclass());
    }

    public boolean isAnnotation() {
        return this.clazz.isAnnotation();
    }

    public boolean isAnonymousClass() {
        return this.clazz.isAnonymousClass();
    }

    public boolean isArray() {
        return this.clazz.isArray();
    }

    public boolean isBooleanType() {
        return "boolean".equals(this.clazz.getName()) || "Boolean".equals(this.clazz.getSimpleName());
    }

    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    public boolean isInstance(Object obj) {
        return this.clazz.isInstance(obj);
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isLocalClass() {
        return this.clazz.isLocalClass();
    }

    public boolean isMemberClass() {
        return this.clazz.isMemberClass();
    }

    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    public boolean isSynthetic() {
        return this.clazz.isSynthetic();
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Set<JavaMethod.FieldMethodInvocation> getFieldMethodInvocationSequences() {
        LinkedHashSet<JavaMethod.FieldMethodInvocation> set = new LinkedHashSet<JavaMethod.FieldMethodInvocation>();
        for (JavaMethod m : this.getMethods()) {
            set.addAll(m.getFieldMethodInvocationSequences());
        }
        return set;
    }

    private Method[] filterByModifiers(Method[] methods, int ... filteredModifiers) {
        ArrayList<Method> filtered = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            for (int j = 0; j < filteredModifiers.length; ++j) {
                if ((filteredModifiers[j] & methods[i].getModifiers()) == 0) continue;
                filtered.add(methods[i]);
            }
        }
        return filtered.toArray(new Method[0]);
    }

    private JavaMethod[] toJavaMethods(Method[] declaredMethods) {
        JavaMethod[] methods = new JavaMethod[declaredMethods.length];
        for (int i = 0; i < declaredMethods.length; ++i) {
            methods[i] = new JavaMethod(declaredMethods[i], this);
        }
        return methods;
    }

    private <T> List<T> exclude(T[] methods, T[] excludeMethods) {
        ArrayList<T> result = new ArrayList<T>();
        block0: for (int i = 0; i < methods.length; ++i) {
            for (int j = 0; j < excludeMethods.length; ++j) {
                if (methods[i].equals(excludeMethods[j])) break block0;
            }
            result.add(methods[i]);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaClass other = (JavaClass)obj;
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }

    public String toString() {
        return this.clazz.getName();
    }

    public static class MavenHelper {
        public static String getMavenJavaTestSourceFile(String clazzFile) {
            if (clazzFile == null) {
                return null;
            }
            clazzFile = clazzFile.replace('\\', '/');
            if ((clazzFile = clazzFile.replaceAll("\\w+\\$", "")).indexOf("target/classes") >= 0) {
                String result = StringHelper.replace(clazzFile, "target/classes", "src/test/java");
                return StringHelper.replace(result, ".class", "Test.java");
            }
            if (clazzFile.indexOf("target/test-classes") >= 0) {
                String result = StringHelper.replace(clazzFile, "target/test-classes", "src/test/java");
                return StringHelper.replace(result, ".class", "Test.java");
            }
            return null;
        }

        public static String getMavenJavaSourceFile(String clazzFile) {
            if (clazzFile == null) {
                return null;
            }
            clazzFile = clazzFile.replace('\\', '/');
            if ((clazzFile = clazzFile.replaceAll("\\$\\w+", "")).indexOf("target/classes") >= 0) {
                String result = StringHelper.replace(clazzFile, "target/classes", "src/main/java");
                return StringHelper.replace(result, ".class", ".java");
            }
            if (clazzFile.indexOf("target/test-classes") >= 0) {
                String result = StringHelper.replace(clazzFile, "target/test-classes", "src/test/java");
                return StringHelper.replace(result, ".class", ".java");
            }
            return null;
        }
    }
}

