/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.db.table.model;

import cn.org.rapid_framework.generator.provider.db.table.model.ForeignKey;
import cn.org.rapid_framework.generator.provider.db.table.model.Table;
import cn.org.rapid_framework.generator.util.ListHashtable;
import java.io.Serializable;

public class ForeignKeys
implements Serializable {
    protected Table parentTable;
    protected ListHashtable associatedTables;

    public ForeignKeys(Table aTable) {
        this.parentTable = aTable;
        this.associatedTables = new ListHashtable();
    }

    public void addForeignKey(String tableName, String columnName, String parentColumn, Integer seq) {
        ForeignKey tbl = null;
        if (this.associatedTables.containsKey(tableName)) {
            tbl = (ForeignKey)this.associatedTables.get(tableName);
        } else {
            tbl = new ForeignKey(this.parentTable, tableName);
            this.associatedTables.put(tableName, tbl);
        }
        tbl.addColumn(columnName, parentColumn, seq);
    }

    public ListHashtable getAssociatedTables() {
        return this.associatedTables;
    }

    public int getSize() {
        return this.getAssociatedTables().size();
    }

    public boolean getHasImportedKeyColumn(String aColumn) {
        boolean isFound = false;
        int numKeys = this.getAssociatedTables().size();
        for (int i = 0; i < numKeys; ++i) {
            ForeignKey aKey = (ForeignKey)this.getAssociatedTables().getOrderedValue(i);
            if (!aKey.getHasImportedKeyColumn(aColumn)) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public ForeignKey getAssociatedTable(String name) {
        Object fkey = this.getAssociatedTables().get(name);
        if (fkey != null) {
            return (ForeignKey)fkey;
        }
        return null;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public boolean getHasImportedKeyParentColumn(String aColumn) {
        boolean isFound = false;
        int numKeys = this.getAssociatedTables().size();
        for (int i = 0; i < numKeys; ++i) {
            ForeignKey aKey = (ForeignKey)this.getAssociatedTables().getOrderedValue(i);
            if (!aKey.getHasImportedKeyParentColumn(aColumn)) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public ForeignKey getImportedKeyParentColumn(String aColumn) {
        ForeignKey aKey = null;
        int numKeys = this.getAssociatedTables().size();
        for (int i = 0; i < numKeys && !(aKey = (ForeignKey)this.getAssociatedTables().getOrderedValue(i)).getHasImportedKeyParentColumn(aColumn); ++i) {
        }
        return aKey;
    }
}

