/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.db.table.model;

import cn.org.rapid_framework.generator.provider.db.table.model.Column;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSet
implements Serializable {
    private static final long serialVersionUID = -6500047411657968878L;
    private LinkedHashSet<Column> columns = new LinkedHashSet();

    public ColumnSet() {
    }

    public ColumnSet(Collection<? extends Column> columns) {
        this.columns = new LinkedHashSet<Column>(columns);
    }

    public LinkedHashSet<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(LinkedHashSet<Column> columns) {
        this.columns = columns;
    }

    public void addColumn(Column c) {
        this.columns.add(c);
    }

    public Column getBySqlName(String name, int sqlType) {
        for (Column c : this.columns) {
            if (!name.equalsIgnoreCase(c.getSqlName()) || c.getSqlType() != sqlType) continue;
            return c;
        }
        return null;
    }

    public Column getBySqlName(String name) {
        if (name == null) {
            return null;
        }
        for (Column c : this.columns) {
            if (!name.equalsIgnoreCase(c.getSqlName())) continue;
            return c;
        }
        return null;
    }

    public Column getByName(String name) {
        if (name == null) {
            return null;
        }
        Column c = this.getBySqlName(name);
        if (c == null) {
            c = this.getBySqlName(StringHelper.toUnderscoreName(name));
        }
        return c;
    }

    public Column getByName(String name, int sqlType) {
        Column c = this.getBySqlName(name, sqlType);
        if (c == null) {
            c = this.getBySqlName(StringHelper.toUnderscoreName(name), sqlType);
        }
        return c;
    }

    public Column getByColumnName(String name) {
        if (name == null) {
            return null;
        }
        for (Column c : this.columns) {
            if (!name.equals(c.getColumnName())) continue;
            return c;
        }
        return null;
    }

    public List<Column> getPkColumns() {
        ArrayList<Column> results = new ArrayList<Column>();
        for (Column c : this.getColumns()) {
            if (!c.isPk()) continue;
            results.add(c);
        }
        return results;
    }

    public List<Column> getNotPkColumns() {
        ArrayList<Column> results = new ArrayList<Column>();
        for (Column c : this.getColumns()) {
            if (c.isPk()) continue;
            results.add(c);
        }
        return results;
    }

    public int getPkCount() {
        int pkCount = 0;
        for (Column c : this.columns) {
            if (!c.isPk()) continue;
            ++pkCount;
        }
        return pkCount;
    }

    public Column getPkColumn() {
        if (this.getPkColumns().isEmpty()) {
            return null;
        }
        return this.getPkColumns().get(0);
    }

    public List<Column> getEnumColumns() {
        ArrayList<Column> results = new ArrayList<Column>();
        for (Column c : this.getColumns()) {
            if (c.isEnumColumn()) continue;
            results.add(c);
        }
        return results;
    }
}

