/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.db.table;

import cn.org.rapid_framework.generator.GeneratorConstants;
import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.provider.db.DataSourceProvider;
import cn.org.rapid_framework.generator.provider.db.table.TableFactoryListener;
import cn.org.rapid_framework.generator.provider.db.table.model.Column;
import cn.org.rapid_framework.generator.provider.db.table.model.Table;
import cn.org.rapid_framework.generator.util.BeanHelper;
import cn.org.rapid_framework.generator.util.DBHelper;
import cn.org.rapid_framework.generator.util.FileHelper;
import cn.org.rapid_framework.generator.util.GLogger;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.XMLHelper;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFactory {
    private static TableFactory instance = null;
    private String schema;
    private String catalog;
    private List<TableFactoryListener> tableFactoryListeners = new ArrayList<TableFactoryListener>();

    private TableFactory(String schema, String catalog) {
        this.schema = schema;
        this.catalog = catalog;
    }

    public static synchronized TableFactory getInstance() {
        if (instance == null) {
            instance = new TableFactory(GeneratorProperties.getNullIfBlank(GeneratorConstants.JDBC_SCHEMA), GeneratorProperties.getNullIfBlank(GeneratorConstants.JDBC_CATALOG));
        }
        return instance;
    }

    public List<TableFactoryListener> getTableFactoryListeners() {
        return this.tableFactoryListeners;
    }

    public void setTableFactoryListeners(List<TableFactoryListener> tableFactoryListeners) {
        this.tableFactoryListeners = tableFactoryListeners;
    }

    public boolean addTableFactoryListener(TableFactoryListener o) {
        return this.tableFactoryListeners.add(o);
    }

    public void clearTableFactoryListener() {
        this.tableFactoryListeners.clear();
    }

    public boolean removeTableFactoryListener(TableFactoryListener o) {
        return this.tableFactoryListeners.remove(o);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public List getAllTables() {
        Connection conn = DataSourceProvider.getConnection();
        try {
            List tables = new TableCreateProcessor(conn, this.getSchema(), this.getCatalog()).getAllTables();
            for (Table t : tables) {
                this.dispatchOnTableCreatedEvent(t);
            }
            List list = tables;
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DBHelper.close(conn);
        }
    }

    private void dispatchOnTableCreatedEvent(Table t) {
        for (TableFactoryListener listener : this.tableFactoryListeners) {
            listener.onTableCreated(t);
        }
    }

    public Table getTable(String tableName) {
        return this.getTable(this.getSchema(), tableName);
    }

    private Table getTable(String schema, String tableName) {
        return this.getTable(this.getCatalog(), schema, tableName);
    }

    private Table getTable(String catalog, String schema, String tableName) {
        Table t = null;
        try {
            t = this._getTable(catalog, schema, tableName);
            if (t == null && !tableName.equals(tableName.toUpperCase())) {
                t = this._getTable(catalog, schema, tableName.toUpperCase());
            }
            if (t == null && !tableName.equals(tableName.toLowerCase())) {
                t = this._getTable(catalog, schema, tableName.toLowerCase());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            Connection conn = DataSourceProvider.getConnection();
            try {
                throw new NotFoundTableException("not found table with give name:" + tableName + (DatabaseMetaDataUtils.isOracleDataBase(DatabaseMetaDataUtils.getMetaData(conn)) ? " \n databaseStructureInfo:" + DatabaseMetaDataUtils.getDatabaseStructureInfo(DatabaseMetaDataUtils.getMetaData(conn), schema, catalog) : "") + "\n current " + DataSourceProvider.getDataSource() + " current schema:" + this.getSchema() + " current catalog:" + this.getCatalog());
            }
            catch (Throwable throwable) {
                DBHelper.close(conn);
                throw throwable;
            }
        }
        this.dispatchOnTableCreatedEvent(t);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table _getTable(String catalog, String schema, String tableName) throws SQLException {
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("tableName must be not empty");
        }
        catalog = StringHelper.defaultIfEmpty(catalog, null);
        schema = StringHelper.defaultIfEmpty(schema, null);
        Connection conn = DataSourceProvider.getConnection();
        DatabaseMetaData dbMetaData = conn.getMetaData();
        ResultSet rs = dbMetaData.getTables(catalog, schema, tableName, null);
        try {
            if (rs.next()) {
                Table table;
                Table table2 = table = new TableCreateProcessor(conn, this.getSchema(), this.getCatalog()).createTable(rs);
                return table2;
            }
        }
        finally {
            DBHelper.close(conn, rs);
        }
        return null;
    }

    public static class DatabaseMetaDataUtils {
        public static boolean isOracleDataBase(DatabaseMetaData metadata) {
            try {
                boolean ret = false;
                ret = metadata.getDatabaseProductName().toLowerCase().indexOf("oracle") != -1;
                return ret;
            }
            catch (SQLException s) {
                return false;
            }
        }

        public static boolean isHsqlDataBase(DatabaseMetaData metadata) {
            try {
                boolean ret = false;
                ret = metadata.getDatabaseProductName().toLowerCase().indexOf("hsql") != -1;
                return ret;
            }
            catch (SQLException s) {
                return false;
            }
        }

        public static boolean isMysqlDataBase(DatabaseMetaData metadata) {
            try {
                boolean ret = false;
                ret = metadata.getDatabaseProductName().toLowerCase().indexOf("mysql") != -1;
                return ret;
            }
            catch (SQLException s) {
                return false;
            }
        }

        public static DatabaseMetaData getMetaData(Connection connection) {
            try {
                return connection.getMetaData();
            }
            catch (SQLException e) {
                throw new RuntimeException("cannot get DatabaseMetaData", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getDatabaseStructureInfo(DatabaseMetaData metadata, String schema, String catalog) {
            ResultSet schemaRs = null;
            ResultSet catalogRs = null;
            String nl = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer(nl);
            sb.append("Configured schema:").append(schema).append(nl);
            sb.append("Configured catalog:").append(catalog).append(nl);
            try {
                schemaRs = metadata.getSchemas();
                sb.append("Available schemas:").append(nl);
                while (schemaRs.next()) {
                    sb.append("  ").append(schemaRs.getString("TABLE_SCHEM")).append(nl);
                }
            }
            catch (SQLException e2) {
                GLogger.warn("Couldn't get schemas", e2);
                sb.append("  ?? Couldn't get schemas ??").append(nl);
            }
            finally {
                DBHelper.close(schemaRs);
            }
            try {
                catalogRs = metadata.getCatalogs();
                sb.append("Available catalogs:").append(nl);
                while (catalogRs.next()) {
                    sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
                }
            }
            catch (SQLException e2) {
                GLogger.warn("Couldn't get catalogs", e2);
                sb.append("  ?? Couldn't get catalogs ??").append(nl);
            }
            finally {
                DBHelper.close(catalogRs);
            }
            return sb.toString();
        }
    }

    static class ExecuteSqlHelper {
        ExecuteSqlHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String queryForString(Connection conn, String sql) {
            String string;
            ResultSet rs;
            Statement s;
            block5: {
                s = null;
                rs = null;
                s = conn.createStatement();
                rs = s.executeQuery(sql);
                if (!rs.next()) break block5;
                String string2 = rs.getString(1);
                DBHelper.close(null, s, rs);
                return string2;
            }
            try {
                string = null;
            }
            catch (SQLException e) {
                String string3;
                try {
                    e.printStackTrace();
                    string3 = null;
                }
                catch (Throwable throwable) {
                    DBHelper.close(null, s, rs);
                    throw throwable;
                }
                DBHelper.close(null, s, rs);
                return string3;
            }
            DBHelper.close(null, s, rs);
            return string;
        }
    }

    public static class TableOverrideValuesProvider {
        private static Map getTableConfigValues(String tableSqlName) {
            XMLHelper.NodeData nd = TableOverrideValuesProvider.getTableConfigXmlNodeData(tableSqlName);
            if (nd == null) {
                return new HashMap();
            }
            return nd == null ? new LinkedHashMap<String, String>() : nd.attributes;
        }

        private static Map getColumnConfigValues(Table table, Column column) {
            XMLHelper.NodeData root = TableOverrideValuesProvider.getTableConfigXmlNodeData(table.getSqlName());
            if (root != null) {
                for (XMLHelper.NodeData item : root.childs) {
                    if (!item.nodeName.equals("column") || !column.getSqlName().equalsIgnoreCase(item.attributes.get("sqlName"))) continue;
                    return item.attributes;
                }
            }
            return new HashMap();
        }

        private static XMLHelper.NodeData getTableConfigXmlNodeData(String tableSqlName) {
            XMLHelper.NodeData nd = TableOverrideValuesProvider.getTableConfigXmlNodeData0(tableSqlName);
            if (nd == null && (nd = TableOverrideValuesProvider.getTableConfigXmlNodeData0(tableSqlName.toLowerCase())) == null) {
                nd = TableOverrideValuesProvider.getTableConfigXmlNodeData0(tableSqlName.toUpperCase());
            }
            return nd;
        }

        private static XMLHelper.NodeData getTableConfigXmlNodeData0(String tableSqlName) {
            try {
                File file = FileHelper.getFileByClassLoader("generator_config/table/" + tableSqlName + ".xml");
                GLogger.trace("getTableConfigXml() load nodeData by tableSqlName:" + tableSqlName + ".xml");
                return new XMLHelper().parseXML(file);
            }
            catch (Exception e) {
                GLogger.trace("not found config xml for table:" + tableSqlName + ", exception:" + e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCreateProcessor {
        private Connection connection;
        private String catalog;
        private String schema;

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public TableCreateProcessor(Connection connection, String schema, String catalog) {
            this.connection = connection;
            this.schema = schema;
            this.catalog = catalog;
        }

        public Table createTable(ResultSet rs) throws SQLException {
            long start = System.currentTimeMillis();
            String tableName = null;
            try {
                ResultSetMetaData rsMetaData = rs.getMetaData();
                String schemaName = rs.getString("TABLE_SCHEM") == null ? "" : rs.getString("TABLE_SCHEM");
                tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String remarks = rs.getString("REMARKS");
                if (remarks == null && DatabaseMetaDataUtils.isOracleDataBase(this.connection.getMetaData())) {
                    remarks = this.getOracleTableComments(tableName);
                }
                Table table = new Table();
                table.setSchema(this.schema);
                table.setCatalog(this.catalog);
                table.setSqlName(tableName);
                table.setRemarks(remarks);
                if ("SYNONYM".equals(tableType) && DatabaseMetaDataUtils.isOracleDataBase(this.connection.getMetaData())) {
                    String[] ownerAndTableName = this.getSynonymOwnerAndTableName(tableName);
                    table.setOwnerSynonymName(ownerAndTableName[0]);
                    table.setTableSynonymName(ownerAndTableName[1]);
                }
                this.retriveTableColumns(table);
                table.initExportedKeys(this.connection.getMetaData());
                table.initImportedKeys(this.connection.getMetaData());
                BeanHelper.copyProperties((Object)table, TableOverrideValuesProvider.getTableConfigValues(table.getSqlName()));
                Table table2 = table;
                return table2;
            }
            catch (SQLException e) {
                throw new RuntimeException("create table object error,tableName:" + tableName, e);
            }
            finally {
                GLogger.perf("createTable() cost:" + (System.currentTimeMillis() - start) + " tableName:" + tableName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Table> getAllTables() throws SQLException {
            DatabaseMetaData dbMetaData = this.connection.getMetaData();
            ResultSet rs = dbMetaData.getTables(this.getCatalog(), this.getSchema(), null, null);
            try {
                ArrayList<Table> tables = new ArrayList<Table>();
                while (rs.next()) {
                    tables.add(this.createTable(rs));
                }
                ArrayList<Table> arrayList = tables;
                return arrayList;
            }
            finally {
                DBHelper.close(rs);
            }
        }

        private String[] getSynonymOwnerAndTableName(String synonymName) {
            PreparedStatement ps = null;
            ResultSet rs = null;
            String[] ret = new String[2];
            try {
                ps = this.connection.prepareStatement("select table_owner,table_name from sys.all_synonyms where synonym_name=? and owner=?");
                ps.setString(1, synonymName);
                ps.setString(2, this.getSchema());
                rs = ps.executeQuery();
                if (!rs.next()) {
                    String databaseStructure = DatabaseMetaDataUtils.getDatabaseStructureInfo(this.getMetaData(), this.schema, this.catalog);
                    throw new RuntimeException("Wow! Synonym " + synonymName + " not found. How can it happen? " + databaseStructure);
                }
                ret[0] = rs.getString(1);
                ret[1] = rs.getString(2);
            }
            catch (SQLException e) {
                try {
                    String databaseStructure = DatabaseMetaDataUtils.getDatabaseStructureInfo(this.getMetaData(), this.schema, this.catalog);
                    GLogger.error(e.getMessage(), e);
                    throw new RuntimeException("Exception in getting synonym owner " + databaseStructure);
                }
                catch (Throwable throwable) {
                    DBHelper.close(null, ps, rs);
                    throw throwable;
                }
            }
            DBHelper.close(null, ps, rs);
            return ret;
        }

        private DatabaseMetaData getMetaData() {
            return DatabaseMetaDataUtils.getMetaData(this.connection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void retriveTableColumns(Table table) throws SQLException {
            GLogger.trace("-------setColumns(" + table.getSqlName() + ")");
            List<String> primaryKeys = this.getTablePrimaryKeys(table);
            table.setPrimaryKeyColumns(primaryKeys);
            LinkedList<String> indices = new LinkedList<String>();
            HashMap<String, String> uniqueIndices = new HashMap<String, String>();
            HashMap<String, ArrayList<String>> uniqueColumns = new HashMap<String, ArrayList<String>>();
            ResultSet indexRs = null;
            try {
                indexRs = table.getOwnerSynonymName() != null ? this.getMetaData().getIndexInfo(this.getCatalog(), table.getOwnerSynonymName(), table.getTableSynonymName(), false, true) : this.getMetaData().getIndexInfo(this.getCatalog(), this.getSchema(), table.getSqlName(), false, true);
                while (indexRs.next()) {
                    String columnName = indexRs.getString("COLUMN_NAME");
                    if (columnName != null) {
                        GLogger.trace("index:" + columnName);
                        indices.add(columnName);
                    }
                    String indexName = indexRs.getString("INDEX_NAME");
                    boolean nonUnique = indexRs.getBoolean("NON_UNIQUE");
                    if (nonUnique || columnName == null || indexName == null) continue;
                    ArrayList<String> l = (ArrayList<String>)uniqueColumns.get(indexName);
                    if (l == null) {
                        l = new ArrayList<String>();
                        uniqueColumns.put(indexName, l);
                    }
                    l.add(columnName);
                    uniqueIndices.put(columnName, indexName);
                    GLogger.trace("unique:" + columnName + " (" + indexName + ")");
                }
            }
            catch (Throwable t) {
                DBHelper.close(indexRs);
                catch (Throwable throwable) {
                    DBHelper.close(indexRs);
                    throw throwable;
                }
            }
            DBHelper.close(indexRs);
            List columns = this.getTableColumns(table, primaryKeys, indices, uniqueIndices, uniqueColumns);
            for (Column column : columns) {
                table.addColumn(column);
            }
            if (primaryKeys.size() == 0) {
                GLogger.warn("WARNING: The JDBC driver didn't report any primary key columns in " + table.getSqlName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getTableColumns(Table table, List primaryKeys, List indices, Map uniqueIndices, Map uniqueColumns) throws SQLException {
            LinkedList<Column> columns = new LinkedList<Column>();
            ResultSet columnRs = this.getColumnsResultSet(table);
            try {
                while (columnRs.next()) {
                    boolean isUnique;
                    int sqlType = columnRs.getInt("DATA_TYPE");
                    String sqlTypeName = columnRs.getString("TYPE_NAME");
                    String columnName = columnRs.getString("COLUMN_NAME");
                    String columnDefaultValue = columnRs.getString("COLUMN_DEF");
                    String remarks = columnRs.getString("REMARKS");
                    if (remarks == null && DatabaseMetaDataUtils.isOracleDataBase(this.connection.getMetaData())) {
                        remarks = this.getOracleColumnComments(table.getSqlName(), columnName);
                    }
                    boolean isNullable = 1 == columnRs.getInt("NULLABLE");
                    int size = columnRs.getInt("COLUMN_SIZE");
                    int decimalDigits = columnRs.getInt("DECIMAL_DIGITS");
                    boolean isPk = primaryKeys.contains(columnName);
                    boolean isIndexed = indices.contains(columnName);
                    String uniqueIndex = (String)uniqueIndices.get(columnName);
                    List columnsInUniqueIndex = null;
                    if (uniqueIndex != null) {
                        columnsInUniqueIndex = (List)uniqueColumns.get(uniqueIndex);
                    }
                    boolean bl = isUnique = columnsInUniqueIndex != null && columnsInUniqueIndex.size() == 1;
                    if (isUnique) {
                        GLogger.trace("unique column:" + columnName);
                    }
                    Column column = new Column(table, sqlType, sqlTypeName, columnName, size, decimalDigits, isPk, isNullable, isIndexed, isUnique, columnDefaultValue, remarks);
                    BeanHelper.copyProperties((Object)column, TableOverrideValuesProvider.getColumnConfigValues(table, column));
                    columns.add(column);
                }
            }
            finally {
                DBHelper.close(columnRs);
            }
            return columns;
        }

        private ResultSet getColumnsResultSet(Table table) throws SQLException {
            ResultSet columnRs = null;
            columnRs = table.getOwnerSynonymName() != null ? this.getMetaData().getColumns(this.getCatalog(), table.getOwnerSynonymName(), table.getTableSynonymName(), null) : this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table.getSqlName(), null);
            return columnRs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getTablePrimaryKeys(Table table) throws SQLException {
            LinkedList<String> primaryKeys = new LinkedList<String>();
            ResultSet primaryKeyRs = null;
            try {
                primaryKeyRs = table.getOwnerSynonymName() != null ? this.getMetaData().getPrimaryKeys(this.getCatalog(), table.getOwnerSynonymName(), table.getTableSynonymName()) : this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table.getSqlName());
                while (primaryKeyRs.next()) {
                    String columnName = primaryKeyRs.getString("COLUMN_NAME");
                    GLogger.trace("primary key:" + columnName);
                    primaryKeys.add(columnName);
                }
            }
            catch (Throwable throwable) {
                DBHelper.close(primaryKeyRs);
                throw throwable;
            }
            DBHelper.close(primaryKeyRs);
            return primaryKeys;
        }

        private String getOracleTableComments(String table) {
            String sql = "SELECT comments FROM user_tab_comments WHERE table_name='" + table + "'";
            return ExecuteSqlHelper.queryForString(this.connection, sql);
        }

        private String getOracleColumnComments(String table, String column) {
            String sql = "SELECT comments FROM user_col_comments WHERE table_name='" + table + "' AND column_name = '" + column + "'";
            return ExecuteSqlHelper.queryForString(this.connection, sql);
        }
    }

    public static class NotFoundTableException
    extends RuntimeException {
        private static final long serialVersionUID = 5976869128012158628L;

        public NotFoundTableException(String message) {
            super(message);
        }
    }
}

