/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.db.sql.model;

import cn.org.rapid_framework.generator.provider.db.sql.model.Sql;
import cn.org.rapid_framework.generator.provider.db.sql.model.SqlParameter;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.sqlparse.NamedParameterUtils;
import cn.org.rapid_framework.generator.util.sqlparse.ParsedSql;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSegment {
    public String id;
    public String rawIncludeSql;
    public String parsedIncludeSql;
    public Set<SqlParameter> params;

    public SqlSegment() {
    }

    public SqlSegment(String id, String rawIncludeSql, String parsedIncludeSql) {
        this.setId(id);
        this.rawIncludeSql = rawIncludeSql;
        this.parsedIncludeSql = parsedIncludeSql;
    }

    public Set<SqlParameter> getParams(Sql sql) {
        LinkedHashSet<SqlParameter> result = new LinkedHashSet<SqlParameter>();
        for (String paramName : this.getParamNames()) {
            SqlParameter p = sql.getParam(paramName);
            if (p == null) {
                throw new IllegalArgumentException("not found param on sql:" + this.parsedIncludeSql + " with name:" + paramName + " for sqlSegment:" + this.id);
            }
            result.add(p);
        }
        return result;
    }

    public List<String> getParamNames() {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(this.parsedIncludeSql);
        return parsedSql.getParameterNames();
    }

    public String getClassName() {
        return StringHelper.toJavaClassName(this.id.replace(".", "_").replace("-", "_"));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (StringHelper.isBlank(id)) {
            throw new IllegalArgumentException("id must be not blank");
        }
        this.id = id;
    }

    public String getRawIncludeSql() {
        return this.rawIncludeSql;
    }

    public void setRawIncludeSql(String rawIncludeSql) {
        this.rawIncludeSql = rawIncludeSql;
    }

    public String getParsedIncludeSql() {
        return this.parsedIncludeSql;
    }

    public void setParsedIncludeSql(String parsedIncludeSql) {
        this.parsedIncludeSql = parsedIncludeSql;
    }

    public Set<SqlParameter> getParams() {
        return this.params;
    }

    public void setParams(Set<SqlParameter> params) {
        this.params = params;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isGenerateParameterObject() {
        return this.getParamNames().size() > 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlSegment other = (SqlSegment)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

