/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.provider.db;

import cn.org.rapid_framework.generator.GeneratorConstants;
import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.util.GLogger;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceProvider {
    private static Connection connection;
    private static DataSource dataSource;

    public static synchronized Connection getNewConnection() {
        try {
            return DataSourceProvider.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Connection getConnection() {
        try {
            if (connection == null || connection.isClosed()) {
                connection = DataSourceProvider.getDataSource().getConnection();
            }
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setDataSource(DataSource dataSource) {
        DataSourceProvider.dataSource = dataSource;
    }

    public static synchronized DataSource getDataSource() {
        if (dataSource == null && (dataSource = DataSourceProvider.lookupJndiDataSource(GeneratorProperties.getProperty(GeneratorConstants.DATA_SOURCE_JNDI_NAME))) == null) {
            dataSource = new DriverManagerDataSource(GeneratorProperties.getRequiredProperty(GeneratorConstants.JDBC_URL), GeneratorProperties.getRequiredProperty(GeneratorConstants.JDBC_USERNAME), GeneratorProperties.getProperty(GeneratorConstants.JDBC_PASSWORD), GeneratorProperties.getRequiredProperty(GeneratorConstants.JDBC_DRIVER));
        }
        return dataSource;
    }

    private static DataSource lookupJndiDataSource(String name) {
        if (StringHelper.isBlank(name)) {
            return null;
        }
        try {
            InitialContext context = new InitialContext();
            return (DataSource)context.lookup(name);
        }
        catch (NamingException e) {
            GLogger.warn("lookup generator dataSource fail by name:" + name + " cause:" + e.toString() + ",retry by jdbc_url again");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DriverManagerDataSource
    implements DataSource {
        private String url;
        private String username;
        private String password;
        private String driverClass;

        private static void loadJdbcDriver(String driverClass) {
            try {
                if (driverClass == null || "".equals(driverClass.trim())) {
                    throw new IllegalArgumentException("jdbc 'driverClass' must not be empty");
                }
                Class.forName(driverClass.trim());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("not found jdbc driver class:[" + driverClass + "]", e);
            }
        }

        public DriverManagerDataSource(String url, String username, String password, String driverClass) {
            this.url = url;
            this.username = username;
            this.password = password;
            this.driverClass = driverClass;
            DriverManagerDataSource.loadJdbcDriver(driverClass);
        }

        @Override
        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(this.url, this.username, this.password);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return DriverManager.getConnection(this.url, username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException("getLoginTimeout");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (iface == null) {
                throw new IllegalArgumentException("Interface argument must not be null");
            }
            if (!DataSource.class.equals(iface)) {
                throw new SQLException("DataSource of type [" + this.getClass().getName() + "] can only be unwrapped as [javax.sql.DataSource], not as [" + iface.getName());
            }
            return (T)this;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return DataSource.class.equals(iface);
        }

        public String toString() {
            return "DataSource: url=" + this.url + " username=" + this.username;
        }
    }
}

