/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator;

import cn.org.rapid_framework.generator.GeneratorConstants;
import cn.org.rapid_framework.generator.util.GLogger;
import cn.org.rapid_framework.generator.util.PropertiesHelper;
import cn.org.rapid_framework.generator.util.PropertyPlaceholderHelper;
import cn.org.rapid_framework.generator.util.typemapping.DatabaseTypeUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;

public class GeneratorProperties {
    static PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", false);
    static final String[] PROPERTIES_FILE_NAMES = new String[]{"generator.properties", "generator.xml"};
    static PropertiesHelper props = new PropertiesHelper(new Properties(), true);

    private GeneratorProperties() {
    }

    public static void load(String ... files) throws InvalidPropertiesFormatException, IOException {
        GeneratorProperties.putAll(PropertiesHelper.load(files));
    }

    public static void putAll(Properties props) {
        GeneratorProperties.getProperties().putAll((Map<?, ?>)GeneratorProperties.resolveProperties(props));
    }

    public static void clear() {
        GeneratorProperties.getProperties().clear();
    }

    public static void reload() {
        try {
            GLogger.println("Start Load GeneratorPropeties from classpath:" + Arrays.toString(PROPERTIES_FILE_NAMES));
            Properties p = new Properties();
            Object[] loadedFiles = PropertiesHelper.loadAllPropertiesFromClassLoader(p, PROPERTIES_FILE_NAMES);
            GLogger.println("GeneratorPropeties Load Success,files:" + Arrays.toString(loadedFiles));
            GeneratorProperties.setSepicalProperties(p, (String[])loadedFiles);
            GeneratorProperties.setProperties(p);
        }
        catch (IOException e) {
            throw new RuntimeException("Load " + PROPERTIES_FILE_NAMES + " error", e);
        }
    }

    private static void setSepicalProperties(Properties p, String[] loadedFiles) {
        String basedir;
        if (loadedFiles != null && loadedFiles.length > 0 && (basedir = p.getProperty("basedir")) != null && basedir.startsWith(".")) {
            p.setProperty("basedir", new File(new File(loadedFiles[0]).getParent(), basedir).getAbsolutePath());
        }
    }

    public static String getDatabaseType(String key) {
        return GeneratorProperties.getDatabaseType(GeneratorProperties.getProperties(), key);
    }

    public static String getDatabaseType(Map p, String key) {
        if (p.containsKey(key)) {
            return (String)p.get(key);
        }
        String jdbcDriver = (String)p.get(GeneratorConstants.JDBC_DRIVER.code);
        return DatabaseTypeUtils.getDatabaseTypeByJdbcDriver(jdbcDriver);
    }

    private static Properties autoReplacePropertiesValue2DirValue(Properties props) {
        Properties autoReplaceProperties = new Properties();
        for (Object key : GeneratorProperties.getProperties().keySet()) {
            String dir_key = key.toString() + "_dir";
            String value = props.getProperty(key.toString());
            String dir_value = value.toString().replace('.', '/');
            autoReplaceProperties.put(dir_key, dir_value);
        }
        return autoReplaceProperties;
    }

    public static Properties getProperties() {
        return GeneratorProperties.getHelper().getProperties();
    }

    private static PropertiesHelper getHelper() {
        return props;
    }

    public static String getProperty(String key, String defaultValue) {
        return GeneratorProperties.getHelper().getProperty(key, defaultValue);
    }

    public static String getProperty(String key) {
        return GeneratorProperties.getHelper().getProperty(key);
    }

    public static String getProperty(GeneratorConstants key) {
        return GeneratorProperties.getHelper().getProperty(key.code, key.defaultValue);
    }

    public static String getRequiredProperty(String key) {
        return GeneratorProperties.getHelper().getRequiredProperty(key);
    }

    public static String getRequiredProperty(GeneratorConstants key) {
        return GeneratorProperties.getHelper().getRequiredProperty(key.code);
    }

    public static int getRequiredInt(String key) {
        return GeneratorProperties.getHelper().getRequiredInt(key);
    }

    public static boolean getRequiredBoolean(String key) {
        return GeneratorProperties.getHelper().getRequiredBoolean(key);
    }

    public static String getNullIfBlank(String key) {
        return GeneratorProperties.getHelper().getNullIfBlank(key);
    }

    public static String getNullIfBlank(GeneratorConstants key) {
        return GeneratorProperties.getHelper().getNullIfBlank(key.code);
    }

    public static String[] getStringArray(String key) {
        return GeneratorProperties.getHelper().getStringArray(key);
    }

    public static String[] getStringArray(GeneratorConstants key) {
        return GeneratorProperties.getHelper().getStringArray(key.code);
    }

    public static int[] getIntArray(String key) {
        return GeneratorProperties.getHelper().getIntArray(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return GeneratorProperties.getHelper().getBoolean(key, defaultValue);
    }

    public static boolean getBoolean(GeneratorConstants key) {
        return GeneratorProperties.getHelper().getBoolean(key.code, Boolean.parseBoolean(key.defaultValue));
    }

    public static void setProperty(GeneratorConstants key, String value) {
        GeneratorProperties.setProperty(key.code, value);
    }

    public static void setProperty(String key, String value) {
        value = GeneratorProperties.resolveProperty(value, GeneratorProperties.getProperties());
        key = GeneratorProperties.resolveProperty(key, GeneratorProperties.getProperties());
        GLogger.debug("[setProperty()] " + key + "=" + value);
        GeneratorProperties.getHelper().setProperty(key, value);
    }

    private static void assertPropertyKey(String key) {
        if (key.indexOf(".") >= 0) {
            throw new IllegalArgumentException("property\u7684key\u4e0d\u80fd\u5305\u542b\u53e5\u53f7'.'\uff0c\u4f7f\u7528\u4e0b\u5212\u7ebf'_'\u4ee3\u66ff. key=" + key);
        }
    }

    private static Properties resolveProperties(Properties props) {
        Properties result = new Properties();
        for (Object s : props.keySet()) {
            String sourceKey = s.toString();
            String key = GeneratorProperties.resolveProperty(sourceKey, props);
            String value = GeneratorProperties.resolveProperty(props.getProperty(sourceKey), props);
            result.setProperty(key, value);
        }
        return result;
    }

    private static String resolveProperty(String v, Properties props) {
        PropertyPlaceholderHelper.PropertyPlaceholderConfigurerResolver propertyPlaceholderConfigurerResolver = new PropertyPlaceholderHelper.PropertyPlaceholderConfigurerResolver(props);
        return helper.replacePlaceholders(v, propertyPlaceholderConfigurerResolver);
    }

    public static void setProperties(Properties inputProps) {
        props = new PropertiesHelper(GeneratorProperties.resolveProperties(inputProps), true);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            GLogger.debug("[Property] " + entry.getKey() + "=" + entry.getValue());
        }
        GLogger.println("");
    }

    static {
        GeneratorProperties.reload();
    }
}

