/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator;

import cn.org.rapid_framework.generator.Generator;
import cn.org.rapid_framework.generator.GeneratorConstants;
import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.provider.db.sql.model.Sql;
import cn.org.rapid_framework.generator.provider.db.table.TableFactory;
import cn.org.rapid_framework.generator.provider.db.table.model.Table;
import cn.org.rapid_framework.generator.provider.java.model.JavaClass;
import cn.org.rapid_framework.generator.util.BeanHelper;
import cn.org.rapid_framework.generator.util.ClassHelper;
import cn.org.rapid_framework.generator.util.GLogger;
import cn.org.rapid_framework.generator.util.GeneratorException;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneratorFacade {
    private Generator generator = new Generator();

    public GeneratorFacade() {
        if (StringHelper.isNotBlank(GeneratorProperties.getProperty("outRoot"))) {
            this.generator.setOutRootDir(GeneratorProperties.getProperty("outRoot"));
        }
    }

    public static void printAllTableNames() throws Exception {
        PrintUtils.printAllTableNames(TableFactory.getInstance().getAllTables());
    }

    public void deleteOutRootDir() throws IOException {
        this.generator.deleteOutRootDir();
    }

    public void generateByMap(Map ... maps) throws Exception {
        for (Map map : maps) {
            new ProcessUtils().processByMap(map, false);
        }
    }

    public void deleteByMap(Map ... maps) throws Exception {
        for (Map map : maps) {
            new ProcessUtils().processByMap(map, true);
        }
    }

    public void generateBy(Generator.GeneratorModel ... models) throws Exception {
        for (Generator.GeneratorModel model : models) {
            new ProcessUtils().processByGeneratorModel(model, false);
        }
    }

    public void deleteBy(Generator.GeneratorModel ... models) throws Exception {
        for (Generator.GeneratorModel model : models) {
            new ProcessUtils().processByGeneratorModel(model, true);
        }
    }

    public void generateByAllTable() throws Exception {
        new ProcessUtils().processByAllTable(false);
    }

    public void deleteByAllTable() throws Exception {
        new ProcessUtils().processByAllTable(true);
    }

    public void generateByTable(String ... tableNames) throws Exception {
        for (String tableName : tableNames) {
            new ProcessUtils().processByTable(tableName, false);
        }
    }

    public void deleteByTable(String ... tableNames) throws Exception {
        for (String tableName : tableNames) {
            new ProcessUtils().processByTable(tableName, true);
        }
    }

    public void generateByClass(Class ... clazzes) throws Exception {
        for (Class clazz : clazzes) {
            new ProcessUtils().processByClass(clazz, false);
        }
    }

    public void deleteByClass(Class ... clazzes) throws Exception {
        for (Class clazz : clazzes) {
            new ProcessUtils().processByClass(clazz, true);
        }
    }

    public void generateBySql(Sql ... sqls) throws Exception {
        for (Sql sql : sqls) {
            new ProcessUtils().processBySql(sql, false);
        }
    }

    public void deleteBySql(Sql ... sqls) throws Exception {
        for (Sql sql : sqls) {
            new ProcessUtils().processBySql(sql, true);
        }
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrintUtils {
        private PrintUtils() {
        }

        private static void printExceptionsSumary(String msg, String outRoot, List<Exception> exceptions) throws FileNotFoundException {
            File errorFile = new File(outRoot, "generator_error.log");
            if (exceptions != null && exceptions.size() > 0) {
                System.err.println("[Generate Error Summary] : " + msg);
                errorFile.getParentFile().mkdirs();
                PrintStream output = new PrintStream(new FileOutputStream(errorFile));
                for (int i = 0; i < exceptions.size(); ++i) {
                    Exception e = exceptions.get(i);
                    System.err.println("[GENERATE ERROR]:" + e);
                    if (i == 0) {
                        e.printStackTrace();
                    }
                    e.printStackTrace(output);
                }
                output.close();
                System.err.println("***************************************************************");
                System.err.println("* * \u8f93\u51fa\u76ee\u5f55\u5df2\u7ecf\u751f\u6210generator_error.log\u7528\u4e8e\u67e5\u770b\u9519\u8bef ");
                System.err.println("***************************************************************");
            }
        }

        private static void printBeginProcess(String displayText, boolean isDatele) {
            GLogger.println("***************************************************************");
            GLogger.println("* BEGIN " + (isDatele ? " delete by " : " generate by ") + displayText);
            GLogger.println("***************************************************************");
        }

        public static void printAllTableNames(List<Table> tables) throws Exception {
            GLogger.println("\n----All TableNames BEGIN----");
            for (int i = 0; i < tables.size(); ++i) {
                String sqlName = tables.get(i).getSqlName();
                GLogger.println("g.generateTable(\"" + sqlName + "\");");
            }
            GLogger.println("----All TableNames END----");
        }
    }

    public static class GeneratorModelUtils {
        public static Generator.GeneratorModel newGeneratorModel(String key, Object valueObject) {
            Generator.GeneratorModel gm = GeneratorModelUtils.newDefaultGeneratorModel();
            gm.templateModel.put(key, valueObject);
            gm.filePathModel.putAll(BeanHelper.describe(valueObject, new String[0]));
            return gm;
        }

        public static Generator.GeneratorModel newFromMap(Map params) {
            Generator.GeneratorModel gm = GeneratorModelUtils.newDefaultGeneratorModel();
            gm.templateModel.putAll(params);
            gm.filePathModel.putAll(params);
            return gm;
        }

        public static Generator.GeneratorModel newDefaultGeneratorModel() {
            HashMap templateModel = new HashMap();
            templateModel.putAll(GeneratorModelUtils.getShareVars());
            HashMap filePathModel = new HashMap();
            filePathModel.putAll(GeneratorModelUtils.getShareVars());
            return new Generator.GeneratorModel(templateModel, filePathModel);
        }

        public static Map getShareVars() {
            HashMap<Object, Object> templateModel = new HashMap<Object, Object>();
            templateModel.putAll(GeneratorProperties.getProperties());
            templateModel.putAll(System.getProperties());
            templateModel.put("env", System.getenv());
            templateModel.put("now", new Date());
            templateModel.put(GeneratorConstants.DATABASE_TYPE.code, GeneratorProperties.getDatabaseType(GeneratorConstants.DATABASE_TYPE.code));
            templateModel.putAll(GeneratorContext.getContext());
            templateModel.putAll(GeneratorModelUtils.getToolsMap());
            return templateModel;
        }

        private static Map getToolsMap() {
            String[] tools;
            HashMap<String, Object> toolsMap = new HashMap<String, Object>();
            for (String className : tools = GeneratorProperties.getStringArray(GeneratorConstants.GENERATOR_TOOLS_CLASS)) {
                try {
                    Object instance = ClassHelper.newInstance(className);
                    toolsMap.put(Class.forName(className).getSimpleName(), instance);
                    GLogger.debug("put tools class:" + className + " with key:" + Class.forName(className).getSimpleName());
                }
                catch (Exception e) {
                    GLogger.error("cannot load tools by className:" + className + " cause:" + e);
                }
            }
            return toolsMap;
        }
    }

    public class ProcessUtils {
        public void processByGeneratorModel(Generator.GeneratorModel model, boolean isDelete) throws Exception, FileNotFoundException {
            Generator g = GeneratorFacade.this.getGenerator();
            Generator.GeneratorModel targetModel = GeneratorModelUtils.newDefaultGeneratorModel();
            targetModel.filePathModel.putAll(model.filePathModel);
            targetModel.templateModel.putAll(model.templateModel);
            this.processByGeneratorModel(isDelete, g, targetModel);
        }

        public void processByMap(Map params, boolean isDelete) throws Exception, FileNotFoundException {
            Generator g = GeneratorFacade.this.getGenerator();
            Generator.GeneratorModel m = GeneratorModelUtils.newFromMap(params);
            this.processByGeneratorModel(isDelete, g, m);
        }

        public void processBySql(Sql sql, boolean isDelete) throws Exception {
            Generator g = GeneratorFacade.this.getGenerator();
            Generator.GeneratorModel m = GeneratorModelUtils.newGeneratorModel("sql", sql);
            PrintUtils.printBeginProcess("sql:" + sql.getSourceSql(), isDelete);
            this.processByGeneratorModel(isDelete, g, m);
        }

        public void processByClass(Class clazz, boolean isDelete) throws Exception, FileNotFoundException {
            Generator g = GeneratorFacade.this.getGenerator();
            Generator.GeneratorModel m = GeneratorModelUtils.newGeneratorModel("clazz", new JavaClass(clazz));
            PrintUtils.printBeginProcess("JavaClass:" + clazz.getSimpleName(), isDelete);
            this.processByGeneratorModel(isDelete, g, m);
        }

        private void processByGeneratorModel(boolean isDelete, Generator g, Generator.GeneratorModel m) throws Exception, FileNotFoundException {
            try {
                if (isDelete) {
                    g.deleteBy(m.templateModel, m.filePathModel);
                } else {
                    g.generateBy(m.templateModel, m.filePathModel);
                }
            }
            catch (GeneratorException ge) {
                PrintUtils.printExceptionsSumary(ge.getMessage(), GeneratorFacade.this.getGenerator().getOutRootDir(), ge.getExceptions());
                throw ge;
            }
        }

        public void processByTable(String tableName, boolean isDelete) throws Exception {
            if ("*".equals(tableName)) {
                if (isDelete) {
                    GeneratorFacade.this.deleteByAllTable();
                } else {
                    GeneratorFacade.this.generateByAllTable();
                }
                return;
            }
            Generator g = GeneratorFacade.this.getGenerator();
            Table table = TableFactory.getInstance().getTable(tableName);
            try {
                this.processByTable(g, table, isDelete);
            }
            catch (GeneratorException ge) {
                PrintUtils.printExceptionsSumary(ge.getMessage(), GeneratorFacade.this.getGenerator().getOutRootDir(), ge.getExceptions());
                throw ge;
            }
        }

        public void processByAllTable(boolean isDelete) throws Exception {
            List tables = TableFactory.getInstance().getAllTables();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (int i = 0; i < tables.size(); ++i) {
                try {
                    this.processByTable(GeneratorFacade.this.getGenerator(), (Table)tables.get(i), isDelete);
                    continue;
                }
                catch (GeneratorException ge) {
                    exceptions.addAll(ge.getExceptions());
                }
            }
            PrintUtils.printExceptionsSumary("", GeneratorFacade.this.getGenerator().getOutRootDir(), exceptions);
            if (!exceptions.isEmpty()) {
                throw new GeneratorException("batch generate by all table occer error", exceptions);
            }
        }

        public void processByTable(Generator g, Table table, boolean isDelete) throws Exception {
            Generator.GeneratorModel m = GeneratorModelUtils.newGeneratorModel("table", table);
            PrintUtils.printBeginProcess(table.getSqlName() + " => " + table.getClassName(), isDelete);
            if (isDelete) {
                g.deleteBy(m.templateModel, m.filePathModel);
            } else {
                g.generateBy(m.templateModel, m.filePathModel);
            }
        }
    }

    public static class GeneratorContext {
        static ThreadLocal<Map> context = new ThreadLocal();

        public static void clear() {
            Map m = context.get();
            if (m != null) {
                m.clear();
            }
        }

        public static Map getContext() {
            Map map = context.get();
            if (map == null) {
                GeneratorContext.setContext(new HashMap());
            }
            return context.get();
        }

        public static void setContext(Map map) {
            context.set(map);
        }

        public static void put(String key, Object value) {
            GeneratorContext.getContext().put(key, value);
        }
    }
}

