/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.ext.tableconfig.model;

import cn.org.rapid_framework.generator.ext.tableconfig.model.TableConfig;
import cn.org.rapid_framework.generator.provider.db.table.TableFactory;
import cn.org.rapid_framework.generator.provider.db.table.TableFactoryListener;
import cn.org.rapid_framework.generator.provider.db.table.model.Table;
import cn.org.rapid_framework.generator.util.GLogger;
import cn.org.rapid_framework.generator.util.StringHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConfigSet
implements Iterable<TableConfig>,
TableFactoryListener {
    private Set<TableConfig> tableConfigs = new LinkedHashSet<TableConfig>();
    private String _package;

    public TableConfigSet() {
        TableFactory tf = TableFactory.getInstance();
        tf.addTableFactoryListener((TableFactoryListener)this);
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String _package) {
        this._package = _package;
        this.setPackageForTableConfigs();
    }

    public Set<String> getSequences() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (TableConfig c : this.tableConfigs) {
            if (!StringHelper.isNotBlank((String)c.getSequence())) continue;
            result.add(c.getSequence());
        }
        return result;
    }

    public void addTableConfig(TableConfig t) {
        this.setPackageIfBlank(t);
        this.tableConfigs.add(t);
    }

    public Set<TableConfig> getTableConfigs() {
        return Collections.unmodifiableSet(this.tableConfigs);
    }

    public void setTableConfigs(Set<TableConfig> tableConfigs) {
        this.tableConfigs = tableConfigs;
        this.setPackageForTableConfigs();
    }

    private void setPackageForTableConfigs() {
        for (TableConfig t : this.tableConfigs) {
            this.setPackageIfBlank(t);
        }
    }

    private void setPackageIfBlank(TableConfig t) {
        if (StringHelper.isBlank((String)t.getPackage())) {
            t.setPackage(this.getPackage());
        }
    }

    public TableConfig getRequiredBySqlName(String sqlName) {
        TableConfig tc = this.getBySqlName(sqlName);
        if (tc == null) {
            throw new IllegalArgumentException("not found TableConfig on TableConfigSet by sqlName:" + sqlName);
        }
        return tc;
    }

    public TableConfig getBySqlName(String sqlName) {
        for (TableConfig c : this.tableConfigs) {
            if (!sqlName.equalsIgnoreCase(c.getSqlName())) continue;
            return c;
        }
        return null;
    }

    public TableConfig getByClassName(String name) {
        for (TableConfig c : this.tableConfigs) {
            if (!name.equals(c.getClassName())) continue;
            return c;
        }
        return null;
    }

    @Override
    public Iterator<TableConfig> iterator() {
        return this.tableConfigs.iterator();
    }

    public void onTableCreated(Table table) {
        TableConfig tc = this.getBySqlName(table.getSqlName());
        if (tc == null) {
            return;
        }
        tc.customTable(table);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        GLogger.warn((String)"\u6ca1\u6709\u624b\u5de5\u6e05\u9664TableFactoryListener for TableConfigSet");
        TableFactory.getInstance().removeTableFactoryListener((TableFactoryListener)this);
    }
}

