/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.ext.tableconfig;

import cn.org.rapid_framework.generator.provider.db.sql.model.SqlSegment;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.XMLHelper;
import cn.org.rapid_framework.generator.util.sqlparse.SqlParseHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatisSqlMapConfigParser {
    public Map<String, SqlSegment> usedIncludedSqls = new HashMap<String, SqlSegment>();
    private String sourceSql;
    private Map<String, String> includeSqls;
    public String resultSql;

    public String parse(String str) {
        return this.parse(str, new HashMap<String, String>());
    }

    public String parse(String str, Map<String, String> includeSqls) {
        this.sourceSql = str;
        this.includeSqls = includeSqls;
        str = Helper.removeComments("<for_remove_comment>" + str + "</for_remove_comment>");
        str = Helper.removeSelectKeyXmlForInsertSql(str);
        Pattern xmlTagRegex = Pattern.compile("<(/?[\\w#@]+)(.*?)>");
        StringBuffer sql = new StringBuffer();
        Matcher m = xmlTagRegex.matcher(str);
        OpenCloseTag openClose = null;
        while (m.find()) {
            String xmlTag = m.group(1);
            String attributesString = m.group(2);
            LinkedHashMap attributes = XMLHelper.parse2Attributes((String)attributesString);
            if ("include".equals(xmlTag.trim())) {
                this.processIncludeByRefid(includeSqls, sql, m, attributes);
                continue;
            }
            Helper.processForMybatis(sql, xmlTag, attributes);
            String replacement = Helper.getReplacement((String)attributes.get("open"), (String)attributes.get("prepend"));
            StringHelper.appendReplacement((Matcher)m, (StringBuffer)sql, (String)replacement);
            if (openClose != null && openClose.close != null && xmlTag.equals("/" + openClose.xmlTag)) {
                sql.append(openClose.close);
                openClose = null;
            }
            if (attributes.get("close") == null) continue;
            openClose = new OpenCloseTag();
            openClose.xmlTag = xmlTag;
            openClose.close = (String)attributes.get("close");
        }
        this.resultSql = StringHelper.unescapeXml((String)StringHelper.removeXMLCdataTag((String)SqlParseHelper.replaceWhere((String)sql.toString())));
        return this.resultSql;
    }

    public List<SqlSegment> getSqlSegments() {
        return new ArrayList<SqlSegment>(this.usedIncludedSqls.values());
    }

    private void processIncludeByRefid(Map<String, String> includeSqls, StringBuffer sb, Matcher m, Map<String, String> attributes) {
        String refid = attributes.get("refid");
        if (refid == null) {
            m.appendReplacement(sb, "");
        } else {
            String includeValue = includeSqls.get(refid);
            if (includeValue == null) {
                throw new IllegalArgumentException("not found include sql by <include refid='" + refid + "'/>");
            }
            String parsedIncludeValue = this.parse(includeValue, includeSqls);
            this.usedIncludedSqls.put(refid, new SqlSegment(refid, includeValue, parsedIncludeValue));
            StringHelper.appendReplacement((Matcher)m, (StringBuffer)sb, (String)parsedIncludeValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Helper {
        Helper() {
        }

        private static void processForMybatis(StringBuffer sb, String xmlTag, Map<String, String> attributes) {
            if ("where".equals(xmlTag.trim())) {
                sb.append("where");
            }
            if ("set".equals(xmlTag.trim())) {
                sb.append("set");
            }
            if ("foreach".equals(xmlTag.trim())) {
                // empty if block
            }
            if ("trim".equals(xmlTag.trim())) {
                attributes.put("open", attributes.get("prefix"));
                attributes.put("close", attributes.get("suffix"));
            }
        }

        private static String getReplacement(String open, String prepend) {
            String replacement = null;
            replacement = prepend != null ? " " + prepend + " " + StringHelper.defaultString((Object)open) : (StringHelper.isEmpty((String)open) ? "" : " " + open);
            return replacement;
        }

        private static String removeSelectKeyXmlForInsertSql(String str) {
            if (str == null) {
                return null;
            }
            return str.replaceAll("(?s)<selectKey.*?>.*</selectKey>", "");
        }

        public static String removeComments(String str) {
            if (str == null) {
                return null;
            }
            str = str.replaceAll("(?s)<!--.*?-->", "").replaceAll("(?s)/\\*.*?\\*/", "").replace("query not allowed", "");
            return str;
        }
    }

    private static class OpenCloseTag {
        public String close;
        public String xmlTag;

        private OpenCloseTag() {
        }
    }
}

