/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.ext.ant;

import cn.org.rapid_framework.generator.GeneratorFacade;
import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.util.SystemHelper;
import freemarker.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGeneratorTask
extends Task {
    protected Path classpath;
    protected String shareInput;
    protected String input;
    protected String output;
    private boolean openOutputDir = false;
    private String _package;

    public static Properties toProperties(Hashtable properties) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)properties);
        return props;
    }

    private void error(Exception e) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        this.log(out.toString(), 0);
    }

    protected GeneratorFacade createGeneratorFacade(String input, String output) {
        if (input == null) {
            throw new IllegalArgumentException("input must be not null");
        }
        if (output == null) {
            throw new IllegalArgumentException("output must be not null");
        }
        GeneratorProperties.setProperties((Properties)new Properties());
        Properties properties = BaseGeneratorTask.toProperties(this.getProject().getProperties());
        properties.setProperty("basedir", this.getProject().getBaseDir().getAbsolutePath());
        GeneratorProperties.setProperties((Properties)properties);
        GeneratorFacade gf = new GeneratorFacade();
        gf.getGenerator().addTemplateRootDir(input);
        if (this.shareInput != null) {
            gf.getGenerator().addTemplateRootDir(this.shareInput);
        }
        gf.getGenerator().setOutRootDir(output);
        return gf;
    }

    public String getShareInput() {
        return this.shareInput;
    }

    public void setShareInput(String shareInput) {
        this.shareInput = shareInput;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setOpenOutputDir(boolean openOutputDir) {
        this.openOutputDir = openOutputDir;
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String _package) {
        this._package = _package;
    }

    public void setClasspathRef(Reference r) {
        this.classpath = new Path(this.getProject());
        this.classpath.setRefid(r);
    }

    public final void execute() throws BuildException {
        super.execute();
        this.setContextClassLoader();
        try {
            this.executeInternal();
        }
        catch (Exception e) {
            this.error(e);
            throw new BuildException((Throwable)e);
        }
    }

    protected void executeInternal() throws Exception {
        Logger.selectLoggerLibrary((int)0);
        this.executeBefore();
        GeneratorFacade facade = this.createGeneratorFacade(this.input, this.output);
        List<Map> maps = this.getGeneratorContexts();
        if (maps == null) {
            return;
        }
        for (Map map : maps) {
            facade.generateByMap(new Map[]{map});
        }
        if (this.openOutputDir && SystemHelper.isWindowsOS) {
            Runtime.getRuntime().exec("cmd.exe /c start " + this.output);
        }
    }

    private void setContextClassLoader() {
        if (this.classpath == null) {
            String cp = ((AntClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getClasspath();
            this.classpath = new Path(this.getProject(), cp);
        }
        AntClassLoader classloader = new AntClassLoader(this.getProject(), this.classpath, true);
        Thread.currentThread().setContextClassLoader((ClassLoader)classloader);
    }

    protected void executeBefore() throws Exception {
    }

    protected abstract List<Map> getGeneratorContexts() throws Exception;
}

