/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.BaseDatastoreV4Validator;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.ValidationException;

public abstract class DatastoreV4Validator
extends BaseDatastoreV4Validator {
    public DatastoreV4Validator(EntityV4Validator entityValidator) {
        super(entityValidator);
    }

    private void validateReadOptions(DatastoreV4.ReadOptionsOrBuilder readOptions) throws ValidationException {
        ValidationException.validateAssertion(!readOptions.hasReadConsistency() || !readOptions.hasTransaction(), "cannot specify both a read consistency and a transaction", new Object[0]);
    }

    public void validateWriteRequest(DatastoreV4.WriteRequestOrBuilder req) throws ValidationException {
        this.validateMutation(req.getMutationOrBuilder());
    }

    public void validateCommitRequest(DatastoreV4.CommitRequestOrBuilder req) throws ValidationException {
        if (req.hasMutation()) {
            this.validateMutation(req.getMutationOrBuilder());
        }
    }

    public void validateGetRequest(DatastoreV4.GetRequestOrBuilder req) throws ValidationException {
        this.validateReadOptions((DatastoreV4.ReadOptionsOrBuilder)req.getReadOptions());
        this.validateKeys(EntityV4Validator.KeyConstraint.PATH_COMPLETE, req.getKeyOrBuilderList());
    }

    public void validateRunQueryReqeust(DatastoreV4.RunQueryRequestOrBuilder req) throws ValidationException {
        this.validateReadOptions((DatastoreV4.ReadOptionsOrBuilder)req.getReadOptions());
        this.entityValidator.validatePartitionId(req.getPartitionId());
        ValidationException.validateAssertion(!req.getReadOptions().hasReadConsistency() || req.getReadOptions().getReadConsistency() != DatastoreV4.ReadOptions.ReadConsistency.STRONG || this.hasAncestor(req.getQuery().getFilter()), "global queries do not support strong consistency", new Object[0]);
    }
}

