/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.ValidationException;

public abstract class BaseDatastoreV4Validator {
    protected final EntityV4Validator entityValidator;

    public BaseDatastoreV4Validator(EntityV4Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    protected abstract String getKeyPropertyName();

    protected void validateMutation(DatastoreV4.MutationOrBuilder mutation) throws ValidationException {
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getUpsertOrBuilderList());
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getUpdateOrBuilderList());
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getInsertOrBuilderList());
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_INCOMPLETE, mutation.getInsertAutoIdOrBuilderList());
        this.validateKeys(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getDeleteOrBuilderList());
    }

    protected void validateEntities(EntityV4Validator.KeyConstraint keyConstraint, Iterable<? extends EntityV4.EntityOrBuilder> entities) throws ValidationException {
        for (EntityV4.EntityOrBuilder entityOrBuilder : entities) {
            this.entityValidator.validateEntity(keyConstraint, entityOrBuilder);
        }
    }

    protected void validateKeys(EntityV4Validator.KeyConstraint keyConstraint, Iterable<? extends EntityV4.KeyOrBuilder> keys) throws ValidationException {
        for (EntityV4.KeyOrBuilder keyOrBuilder : keys) {
            this.entityValidator.validateKey(keyConstraint, keyOrBuilder);
        }
    }

    protected boolean hasAncestor(DatastoreV4.Filter filter) {
        if (filter.hasPropertyFilter()) {
            return filter.getPropertyFilter().getOperator() == DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR && filter.getPropertyFilter().getProperty().getName().equals(this.getKeyPropertyName());
        }
        if (filter.hasCompositeFilter() && filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND) {
            for (DatastoreV4.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                if (!this.hasAncestor(subFilter)) continue;
                return true;
            }
        }
        return false;
    }
}

