/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.reflect.BaseObjectHandler;
import com.github.mustachejava.reflect.ClassGuard;
import com.github.mustachejava.reflect.DepthGuard;
import com.github.mustachejava.reflect.DotGuard;
import com.github.mustachejava.reflect.GuardedBinding;
import com.github.mustachejava.reflect.MapGuard;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.reflect.NullGuard;
import com.github.mustachejava.reflect.ReflectionWrapper;
import com.github.mustachejava.reflect.WrappedGuard;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReflectionObjectHandler
extends BaseObjectHandler {
    protected static final Method MAP_METHOD;

    public static Object unwrap(ObjectHandler oh, int scopeIndex, Wrapper[] wrappers, Object[] scopes) throws GuardException {
        Object scope = oh.coerce(scopes[scopeIndex]);
        if (wrappers != null) {
            for (Wrapper wrapper : wrappers) {
                scope = oh.coerce(wrapper.call(new Object[]{scope}));
            }
        }
        return scope;
    }

    @Override
    public Wrapper find(String name, Object[] scopes) {
        Wrapper wrapper = null;
        int length = scopes.length;
        ArrayList<Predicate<Object[]>> guards = new ArrayList<Predicate<Object[]>>(scopes.length);
        guards.add(new DepthGuard(length));
        block2: for (int i = length - 1; i >= 0; --i) {
            Wrapper[] foundWrappers;
            int dotIndex;
            Object scope = scopes[i];
            if (scope == null) continue;
            guards.add(new ClassGuard(i, scope));
            ArrayList<Wrapper> wrappers = null;
            String subname = name;
            while ((dotIndex = subname.indexOf(46)) != -1) {
                String lookup = subname.substring(0, dotIndex);
                subname = subname.substring(dotIndex + 1);
                guards.add(new DotGuard(lookup, i, scope));
                ArrayList<Predicate<Object[]>> wrapperGuard = new ArrayList<Predicate<Object[]>>(1);
                wrapper = this.findWrapper(0, null, wrapperGuard, scope, lookup);
                if (wrappers == null) {
                    wrappers = new ArrayList<Wrapper>();
                }
                if (wrapper != null) {
                    wrappers.add(wrapper);
                    try {
                        scope = this.coerce(wrapper.call(new Object[]{scope}));
                    }
                    catch (GuardException e) {
                        throw new AssertionError((Object)e);
                    }
                } else {
                    wrapperGuard.add(new ClassGuard(0, scope));
                    guards.add(new WrappedGuard(this, i, wrappers, wrapperGuard));
                    continue block2;
                }
                if (scope != null) continue;
                wrapperGuard.add(new NullGuard());
                guards.add(new WrappedGuard(this, i, wrappers, wrapperGuard));
                break;
            }
            if ((wrapper = this.findWrapper(i, foundWrappers = wrappers == null ? null : wrappers.toArray(new Wrapper[wrappers.size()]), guards, scope, subname)) != null) break;
        }
        return wrapper == null ? new MissingWrapper(guards.toArray(new Predicate[guards.size()])) : wrapper;
    }

    protected Wrapper findWrapper(int scopeIndex, Wrapper[] wrappers, List<Predicate<Object[]>> guards, Object scope, String name) {
        if ((scope = this.coerce(scope)) == null) {
            return null;
        }
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (!map.containsKey(name)) {
                guards.add(new MapGuard(this, scopeIndex, name, false, wrappers));
                return null;
            }
            guards.add(new MapGuard(this, scopeIndex, name, true, wrappers));
            return this.createWrapper(scopeIndex, wrappers, guards, MAP_METHOD, new Object[]{name});
        }
        AccessibleObject member = this.findMember(scope.getClass(), name);
        return member == null ? null : this.createWrapper(scopeIndex, wrappers, guards, member, null);
    }

    protected Wrapper createWrapper(int scopeIndex, Wrapper[] wrappers, List<? extends Predicate<Object[]>> guard, AccessibleObject member, Object[] arguments) {
        return new ReflectionWrapper(scopeIndex, wrappers, guard.toArray(new Predicate[guard.size()]), member, arguments, this);
    }

    @Override
    public Binding createBinding(String name, TemplateContext tc, Code code) {
        return new GuardedBinding(this, name, tc, code);
    }

    static {
        try {
            MAP_METHOD = Map.class.getMethod("get", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

