/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.SmsVoicePromptSenderResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import org.json.JSONObject;

public class SmsVoicePromptSender {
    int appid;
    String appkey;
    String url = "https://yun.tim.qq.com/v5/tlsvoicesvr/sendvoiceprompt";
    SmsSenderUtil util = new SmsSenderUtil();

    public SmsVoicePromptSender(int appid, String appkey) {
        this.appid = appid;
        this.appkey = appkey;
    }

    public SmsVoicePromptSenderResult send(String nationCode, String phoneNumber, int prompttype, int playtimes, String msg, String ext) throws Exception {
        SmsVoicePromptSenderResult result;
        if (null == ext) {
            ext = "";
        }
        long random = this.util.getRandom();
        long curTime = System.currentTimeMillis() / 1000L;
        ArrayList<String> phoneNumbers = new ArrayList<String>();
        phoneNumbers.add(phoneNumber);
        String sig = this.util.calculateSig(this.appkey, random, msg, curTime, phoneNumbers);
        JSONObject data = new JSONObject();
        JSONObject tel = new JSONObject();
        tel.put("nationcode", (Object)nationCode);
        tel.put("mobile", (Object)phoneNumber);
        data.put("tel", (Object)tel);
        data.put("prompttype", prompttype);
        data.put("promptfile", (Object)msg);
        data.put("playtimes", playtimes);
        data.put("sig", (Object)sig);
        data.put("time", curTime);
        data.put("ext", (Object)ext);
        String wholeUrl = String.format("%s?sdkappid=%d&random=%d", this.url, this.appid, random);
        HttpURLConnection conn = this.util.getPostHttpConn(wholeUrl);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "utf-8");
        wr.write(data.toString());
        wr.flush();
        StringBuilder sb = new StringBuilder();
        int httpRspCode = conn.getResponseCode();
        if (httpRspCode == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject json = new JSONObject(sb.toString());
            result = this.util.jsonToSmsVoicePromptSenderResult(json);
        } else {
            result = new SmsVoicePromptSenderResult();
            result.result = httpRspCode;
            result.errmsg = "http error " + httpRspCode + " " + conn.getResponseMessage();
        }
        return result;
    }
}

