/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.SmsStatusPullCallbackResult;
import com.github.qcloudsms.SmsStatusPullReplyResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import org.json.JSONObject;

public class SmsStatusPuller {
    String url = "https://yun.tim.qq.com/v5/tlssmssvr/pullstatus";
    int appid;
    String appkey;
    SmsSenderUtil util = new SmsSenderUtil();

    public SmsStatusPuller(int appid, String appkey) {
        this.appid = appid;
        this.appkey = appkey;
    }

    public HttpURLConnection constructConnection(int type, int max) throws Exception {
        long random = this.util.getRandom();
        long curTime = System.currentTimeMillis() / 1000L;
        JSONObject data = new JSONObject();
        data.put("sig", (Object)this.util.strToHash(String.format("appkey=%s&random=%d&time=%d", this.appkey, random, curTime)));
        data.put("time", curTime);
        data.put("type", type);
        data.put("max", max);
        String wholeUrl = String.format("%s?sdkappid=%d&random=%d", this.url, this.appid, random);
        HttpURLConnection conn = this.util.getPostHttpConn(wholeUrl);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "utf-8");
        wr.write(data.toString());
        wr.flush();
        return conn;
    }

    public SmsStatusPullCallbackResult pullCallback(int max) throws Exception {
        SmsStatusPullCallbackResult result;
        HttpURLConnection conn = this.constructConnection(0, max);
        StringBuilder sb = new StringBuilder();
        int httpRspCode = conn.getResponseCode();
        if (httpRspCode == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject json = new JSONObject(sb.toString());
            result = this.util.jsonToSmsStatusPullCallbackrResult(json);
        } else {
            result = new SmsStatusPullCallbackResult();
            result.result = httpRspCode;
            result.errmsg = "http error " + httpRspCode + " " + conn.getResponseMessage();
        }
        return result;
    }

    public SmsStatusPullReplyResult pullReply(int max) throws Exception {
        SmsStatusPullReplyResult result;
        HttpURLConnection conn = this.constructConnection(1, max);
        StringBuilder sb = new StringBuilder();
        int httpRspCode = conn.getResponseCode();
        if (httpRspCode == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject json = new JSONObject(sb.toString());
            result = this.util.jsonToSmsStatusPullReplyResult(json);
        } else {
            result = new SmsStatusPullReplyResult();
            result.result = httpRspCode;
            result.errmsg = "http error " + httpRspCode + " " + conn.getResponseMessage();
        }
        return result;
    }
}

