/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.sns.SnsToken;
import weixin.popular.bean.user.User;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.EmojiUtil;

public class SnsAPI
extends BaseAPI {
    public static SnsToken oauth2AccessToken(String appid, String secret, String code) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/sns/oauth2/access_token").addParameter("appid", appid).addParameter("secret", secret).addParameter("code", code).addParameter("grant_type", "authorization_code").build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, SnsToken.class);
    }

    public static SnsToken oauth2ComponentAccessToken(String appid, String code, String component_appid, String component_access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/sns/oauth2/component/access_token").addParameter("appid", appid).addParameter("code", code).addParameter("grant_type", "authorization_code").addParameter("component_appid", component_appid).addParameter("component_access_token", component_access_token).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, SnsToken.class);
    }

    public static SnsToken oauth2RefreshToken(String appid, String refresh_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/sns/oauth2/refresh_token").addParameter("appid", appid).addParameter("refresh_token", refresh_token).addParameter("grant_type", "refresh_token").build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, SnsToken.class);
    }

    public static SnsToken oauth2ComponentRefreshToken(String appid, String refresh_token, String component_appid, String component_access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/sns/oauth2/component/refresh_token").addParameter("appid", appid).addParameter("refresh_token", refresh_token).addParameter("grant_type", "refresh_token").addParameter("component_appid", component_appid).addParameter("component_access_token", component_access_token).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, SnsToken.class);
    }

    public static BaseResult auth(String access_token, String openid) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/sns/auth").addParameter(SnsAPI.getATPN(), access_token).addParameter("openid", openid).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static User userinfo(String access_token, String openid, String lang, int emoji) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/sns/userinfo").addParameter("access_token", access_token).addParameter("openid", openid).addParameter("lang", lang).build();
        User user = LocalHttpClient.executeJsonResult(httpUriRequest, User.class);
        if (emoji != 0 && user != null && user.getNickname() != null) {
            user.setNickname_emoji(EmojiUtil.parse(user.getNickname(), emoji));
        }
        return user;
    }

    public static User userinfo(String access_token, String openid, String lang) {
        return SnsAPI.userinfo(access_token, openid, lang, 0);
    }

    public static String connectOauth2Authorize(String appid, String redirect_uri, boolean snsapi_userinfo, String state) {
        return SnsAPI.connectOauth2Authorize(appid, redirect_uri, snsapi_userinfo, state, null);
    }

    public static String connectOauth2Authorize(String appid, String redirect_uri, boolean snsapi_userinfo, String state, String component_appid) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?").append("appid=").append(appid).append("&redirect_uri=").append(URLEncoder.encode(redirect_uri, "utf-8")).append("&response_type=code").append("&scope=").append(snsapi_userinfo ? "snsapi_userinfo" : "snsapi_base").append("&state=").append(state == null ? "" : state);
            if (component_appid != null) {
                sb.append("&component_appid=").append(component_appid);
            }
            sb.append("#wechat_redirect");
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String connectQrconnect(String appid, String redirect_uri, String state) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://open.weixin.qq.com/connect/qrconnect?").append("appid=").append(appid).append("&redirect_uri=").append(URLEncoder.encode(redirect_uri, "utf-8")).append("&response_type=code").append("&scope=snsapi_login").append("&state=").append(state == null ? "" : state).append("#wechat_redirect");
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

