/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.pay.Delivernotify;
import weixin.popular.bean.pay.OrderInfo;
import weixin.popular.bean.pay.Orderquery;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.MapUtil;
import weixin.popular.util.SignatureUtil;

public class PayAPI
extends BaseAPI {
    private static BaseResult payDelivernotify(String access_token, String delivernotifyJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/pay/delivernotify").addParameter("access_token", access_token).setEntity((HttpEntity)new StringEntity(delivernotifyJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult payfeedbackUpdate(String access_token, String openid, String feedbackid) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/payfeedback/update").addParameter("access_token", access_token).addParameter("openid", openid).addParameter("feedbackid", feedbackid).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    private static OrderInfo payOrderquery(String access_token, String orderqueryJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/pay/orderquery").addParameter("access_token", access_token).setEntity((HttpEntity)new StringEntity(orderqueryJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, OrderInfo.class);
    }

    public static BaseResult payDelivernotify(String access_token, Delivernotify delivernotify, String paySignKey) {
        Map<String, String> map = MapUtil.objectToMap(delivernotify, new String[0]);
        String app_signature = SignatureUtil.generatePaySign(map, paySignKey);
        map.put("app_signature", app_signature);
        map.put("sign_method", "sha1");
        return PayAPI.payDelivernotify(access_token, JsonUtil.toJSONString(map));
    }

    public static OrderInfo payOrderquery(String access_token, Orderquery orderquery, String paySignKey) {
        LinkedHashMap<String, String> tmap = new LinkedHashMap<String, String>();
        tmap.put("out_trade_no", orderquery.getOut_trade_no());
        tmap.put("partner", orderquery.getPartner());
        String packAge = SignatureUtil.generatePackage(tmap, orderquery.getPartner_key());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", orderquery.getAppid());
        map.put("package", packAge);
        map.put("timestamp", orderquery.getTimestamp());
        String app_signature = SignatureUtil.generatePaySign(map, paySignKey);
        map.put("app_signature", app_signature);
        map.put("sign_method", "sha1");
        return PayAPI.payOrderquery(access_token, JsonUtil.toJSONString(map));
    }
}

