/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.card.AbstractCard;
import weixin.popular.bean.card.CardType;
import weixin.popular.bean.card.CashCard;
import weixin.popular.bean.card.DiscountCard;
import weixin.popular.bean.card.GeneralCouponCard;
import weixin.popular.bean.card.GiftCard;
import weixin.popular.bean.card.GrouponCard;
import weixin.popular.bean.card.batchget.BatchGet;
import weixin.popular.bean.card.batchget.BatchGetResult;
import weixin.popular.bean.card.code.checkcode.CodeCheckCode;
import weixin.popular.bean.card.code.checkcode.CodeCheckCodeResult;
import weixin.popular.bean.card.code.consume.CodeConsume;
import weixin.popular.bean.card.code.consume.CodeConsumeResult;
import weixin.popular.bean.card.code.decrypt.CodeDecrypt;
import weixin.popular.bean.card.code.decrypt.CodeDecryptResult;
import weixin.popular.bean.card.code.deposit.CodeDeposit;
import weixin.popular.bean.card.code.deposit.CodeDepositResult;
import weixin.popular.bean.card.code.get.CodeGet;
import weixin.popular.bean.card.code.get.CodeGetResult;
import weixin.popular.bean.card.code.getdepositcount.CodeGetDepositCount;
import weixin.popular.bean.card.code.getdepositcount.CodeGetDepositCountResult;
import weixin.popular.bean.card.code.unavailable.CodeUnavailable;
import weixin.popular.bean.card.code.update.CodeUpdate;
import weixin.popular.bean.card.create.Create;
import weixin.popular.bean.card.create.CreateResult;
import weixin.popular.bean.card.get.AbstractResult;
import weixin.popular.bean.card.get.GetCashResult;
import weixin.popular.bean.card.get.GetDiscountResult;
import weixin.popular.bean.card.get.GetGeneralCouponResult;
import weixin.popular.bean.card.get.GetGrouponResult;
import weixin.popular.bean.card.get.GetResult;
import weixin.popular.bean.card.landingpage.create.LandingPageCreate;
import weixin.popular.bean.card.landingpage.create.LandingPageCreateResult;
import weixin.popular.bean.card.modifystock.ModifyStock;
import weixin.popular.bean.card.mpnews.gethtml.MpNewsGetHtml;
import weixin.popular.bean.card.mpnews.gethtml.MpNewsGetHtmlResult;
import weixin.popular.bean.card.paycell.set.PaySellSet;
import weixin.popular.bean.card.qrcode.create.QrCodeCreate;
import weixin.popular.bean.card.qrcode.create.QrCodeCreateMultiple;
import weixin.popular.bean.card.qrcode.create.QrCodeCreateResult;
import weixin.popular.bean.card.testwhitelist.set.TestWhiteListSet;
import weixin.popular.bean.card.update.UpdateCash;
import weixin.popular.bean.card.update.UpdateDiscount;
import weixin.popular.bean.card.update.UpdateGeneralCoupon;
import weixin.popular.bean.card.update.UpdateGift;
import weixin.popular.bean.card.update.UpdateGroupon;
import weixin.popular.bean.card.update.UpdateResult;
import weixin.popular.bean.card.user.getcardlist.UserGetCardList;
import weixin.popular.bean.card.user.getcardlist.UserGetCardListResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;

public class CardAPI
extends BaseAPI {
    public static BatchGetResult batchGet(String accessToken, BatchGet batchget) {
        return CardAPI.batchGet(accessToken, JsonUtil.toJSONString(batchget));
    }

    public static BatchGetResult batchGet(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/batchget").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BatchGetResult.class);
    }

    public static CodeCheckCodeResult codeCheckCode(String accessToken, CodeCheckCode codeCheck) {
        return CardAPI.codeCheckCode(accessToken, JsonUtil.toJSONString(codeCheck));
    }

    public static CodeCheckCodeResult codeCheckCode(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/checkcode").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CodeCheckCodeResult.class);
    }

    public static CodeDecryptResult codeConsume(String accessToken, CodeConsume codeConsume) {
        return CardAPI.codeConsume(accessToken, JsonUtil.toJSONString(codeConsume));
    }

    public static CodeDecryptResult codeConsume(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/consume").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CodeDecryptResult.class);
    }

    public static CodeConsumeResult codeDecrypt(String accessToken, CodeDecrypt codeDecrypt) {
        return CardAPI.codeDecrypt(accessToken, JsonUtil.toJSONString(codeDecrypt));
    }

    public static CodeConsumeResult codeDecrypt(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/decrypt").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CodeConsumeResult.class);
    }

    public static CodeDepositResult codeDeposit(String accessToken, CodeDeposit codeDeposit) {
        return CardAPI.codeDeposit(accessToken, JsonUtil.toJSONString(codeDeposit));
    }

    public static CodeDepositResult codeDeposit(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/deposit").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CodeDepositResult.class);
    }

    public static CodeGetResult codeGet(String accessToken, CodeGet codeGet) {
        return CardAPI.codeGet(accessToken, JsonUtil.toJSONString(codeGet));
    }

    public static CodeGetResult codeGet(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/get").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CodeGetResult.class);
    }

    public static CodeGetDepositCountResult codeGetDepositCount(String accessToken, CodeGetDepositCount codeCount) {
        return CardAPI.codeGetDepositCount(accessToken, JsonUtil.toJSONString(codeCount));
    }

    public static CodeGetDepositCountResult codeGetDepositCount(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/getdepositcount").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CodeGetDepositCountResult.class);
    }

    public static BaseResult codeUnavailable(String accessToken, CodeUnavailable codeUnavailable) {
        return CardAPI.codeUnavailable(accessToken, JsonUtil.toJSONString(codeUnavailable));
    }

    public static BaseResult codeUnavailable(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/unavailable").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult codeUnavailableByCode(String accessToken, String code) {
        return CardAPI.codeUnavailable(accessToken, String.format("{\"code\": \"%s\"}", code));
    }

    public static BaseResult codeUpdate(String accessToken, CodeUpdate codeUpdate) {
        return CardAPI.codeUpdate(accessToken, JsonUtil.toJSONString(codeUpdate));
    }

    public static BaseResult codeUpdate(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/code/update").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static CreateResult create(String accessToken, Create<?> card) {
        return CardAPI.create(accessToken, JsonUtil.toJSONString(card));
    }

    public static CreateResult create(String accessToken, CashCard cashCard) {
        Create<CashCard> card = new Create<CashCard>();
        card.setCard(cashCard);
        return CardAPI.create(accessToken, card);
    }

    public static CreateResult create(String accessToken, DiscountCard discountCard) {
        Create<DiscountCard> card = new Create<DiscountCard>();
        card.setCard(discountCard);
        return CardAPI.create(accessToken, card);
    }

    public static CreateResult create(String accessToken, GeneralCouponCard generalCouponCard) {
        Create<GeneralCouponCard> card = new Create<GeneralCouponCard>();
        card.setCard(generalCouponCard);
        return CardAPI.create(accessToken, card);
    }

    public static CreateResult create(String accessToken, GiftCard giftCard) {
        Create<GiftCard> card = new Create<GiftCard>();
        card.setCard(giftCard);
        return CardAPI.create(accessToken, card);
    }

    public static CreateResult create(String accessToken, GrouponCard grouponCard) {
        Create<GrouponCard> card = new Create<GrouponCard>();
        card.setCard(grouponCard);
        return CardAPI.create(accessToken, card);
    }

    public static CreateResult create(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/create").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CreateResult.class);
    }

    public static BaseResult delete(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/delete").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult deleteByCardId(String accessToken, String cardId) {
        return CardAPI.delete(accessToken, String.format("{\"card_id\": \"%s\"}", cardId));
    }

    public static GetResult<?> get(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/get").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        AbstractResult abs = LocalHttpClient.executeJsonResult(httpUriRequest, AbstractResult.class);
        if (!abs.isSuccess()) {
            return abs;
        }
        GetResult result = abs;
        CardType cardType = CardType.valueOf(((AbstractCard)abs.getCard()).getCardType().toUpperCase());
        Class clazz = null;
        switch (cardType) {
            case CASH: {
                clazz = GetCashResult.class;
                break;
            }
            case DISCOUNT: {
                clazz = GetDiscountResult.class;
                break;
            }
            case GENERAL_COUPON: {
                clazz = GetGeneralCouponResult.class;
                break;
            }
            case GROUPON: {
                clazz = GetGrouponResult.class;
                break;
            }
        }
        if (null != clazz) {
            result = LocalHttpClient.executeJsonResult(httpUriRequest, clazz);
        }
        return result;
    }

    public static GetResult<?> getByCardId(String accessToken, String cardId) {
        return CardAPI.get(accessToken, String.format("{\"card_id\": \"%s\"}", cardId));
    }

    public static LandingPageCreateResult landingPageCreate(String accessToken, LandingPageCreate landingPage) {
        return CardAPI.landingPageCreate(accessToken, JsonUtil.toJSONString(landingPage));
    }

    public static LandingPageCreateResult landingPageCreate(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/landingpage/create").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, LandingPageCreateResult.class);
    }

    public static BaseResult modifyStock(String accessToken, ModifyStock modifystock) {
        return CardAPI.modifyStock(accessToken, JsonUtil.toJSONString(modifystock));
    }

    public static BaseResult modifyStock(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/modifystock").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static MpNewsGetHtmlResult mpNewsGetHtml(String accessToken, MpNewsGetHtml mpnews) {
        return CardAPI.mpNewsGetHtml(accessToken, JsonUtil.toJSONString(mpnews));
    }

    public static MpNewsGetHtmlResult mpNewsGetHtml(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/mpnews/gethtml").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, MpNewsGetHtmlResult.class);
    }

    public static BaseResult payCellSet(String accessToken, PaySellSet cardSet) {
        return CardAPI.payCellSet(accessToken, JsonUtil.toJSONString(cardSet));
    }

    public static BaseResult payCellSet(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/paycell/set").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static QrCodeCreateResult qrcodeCreate(String accessToken, QrCodeCreate action) {
        return CardAPI.qrcodeCreate(accessToken, JsonUtil.toJSONString(action));
    }

    public static QrCodeCreateResult qrcodeCreate(String accessToken, QrCodeCreateMultiple action) {
        return CardAPI.qrcodeCreate(accessToken, JsonUtil.toJSONString(action));
    }

    public static QrCodeCreateResult qrcodeCreate(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/qrcode/create").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, QrCodeCreateResult.class);
    }

    public static BaseResult selfconsumecellSet(String accessToken, PaySellSet cardSet) {
        return CardAPI.selfconsumecellSet(accessToken, JsonUtil.toJSONString(cardSet));
    }

    public static BaseResult selfconsumecellSet(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/selfconsumecell/set").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult testWhiteListSet(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/testwhitelist/set").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult testWhiteListSet(String accessToken, TestWhiteListSet whiteList) {
        return CardAPI.testWhiteListSet(accessToken, JsonUtil.toJSONString(whiteList));
    }

    public static UpdateResult update(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/update").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, UpdateResult.class);
    }

    public static UpdateResult update(String accessToken, UpdateCash updateCash) {
        return CardAPI.update(accessToken, JsonUtil.toJSONString(updateCash));
    }

    public static UpdateResult update(String accessToken, UpdateDiscount updateDiscount) {
        return CardAPI.update(accessToken, JsonUtil.toJSONString(updateDiscount));
    }

    public static UpdateResult update(String accessToken, UpdateGeneralCoupon updateGeneralCoupon) {
        return CardAPI.update(accessToken, JsonUtil.toJSONString(updateGeneralCoupon));
    }

    public static UpdateResult update(String accessToken, UpdateGift updateGift) {
        return CardAPI.update(accessToken, JsonUtil.toJSONString(updateGift));
    }

    public static UpdateResult update(String accessToken, UpdateGroupon updateGroupon) {
        return CardAPI.update(accessToken, JsonUtil.toJSONString(updateGroupon));
    }

    public static UserGetCardListResult userGetCardList(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/card/user/getcardlist").addParameter(CardAPI.getATPN(), accessToken).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, UserGetCardListResult.class);
    }

    public static UserGetCardListResult userGetCardList(String accessToken, UserGetCardList userGetCardList) {
        return CardAPI.userGetCardList(accessToken, JsonUtil.toJSONString(userGetCardList));
    }
}

