/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.api.TokenAPI;
import weixin.popular.bean.token.Token;

public class TokenManager {
    private static final Logger logger = LoggerFactory.getLogger(TokenManager.class);
    private static ScheduledExecutorService scheduledExecutorService;
    private static Map<String, String> tokenMap;
    private static Map<String, ScheduledFuture<?>> futureMap;
    private static int poolSize;
    private static boolean daemon;

    private static void initScheduledExecutorService() {
        logger.info("daemon:{},poolSize:{}", (Object)daemon, (Object)poolSize);
        scheduledExecutorService = Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread thread = Executors.defaultThreadFactory().newThread(arg0);
                thread.setDaemon(daemon);
                return thread;
            }
        });
    }

    public static void setPoolSize(int poolSize) {
        TokenManager.poolSize = poolSize;
    }

    public static void setDaemon(boolean daemon) {
        TokenManager.daemon = daemon;
    }

    public static void init(final String appid, final String secret) {
        if (scheduledExecutorService == null) {
            TokenManager.initScheduledExecutorService();
        }
        if (futureMap.containsKey(appid)) {
            futureMap.get(appid).cancel(true);
        }
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Token token = TokenAPI.token(appid, secret);
                tokenMap.put(appid, token.getAccess_token());
                logger.info("ACCESS_TOKEN refurbish with appid:{}", (Object)appid);
            }
        }, 0L, 118L, TimeUnit.MINUTES);
        futureMap.put(appid, scheduledFuture);
        logger.info("appid:{}", (Object)appid);
    }

    public static void destroyed() {
        scheduledExecutorService.shutdownNow();
        logger.info("destroyed");
    }

    public static String getToken(String appid) {
        return tokenMap.get(appid);
    }

    public static String getDefaultToken() {
        Object[] objs = tokenMap.values().toArray();
        return objs.length > 0 ? objs[0].toString() : null;
    }

    static {
        tokenMap = new LinkedHashMap<String, String>();
        futureMap = new HashMap();
        poolSize = 2;
        daemon = Boolean.TRUE;
    }
}

