/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts.json;

import com.alibaba.fastjson.JSON;
import com.github.abel533.echarts.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonUtil {
    public static String format(Object object) {
        String prettyJsonString = JSON.toJSONString((Object)object);
        String[] lines = prettyJsonString.split("\n");
        lines = FastJsonUtil.replaceFunctionQuote(lines);
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public static String prettyFormat(Object object) {
        String prettyJsonString = JSON.toJSONString((Object)object);
        String[] lines = prettyJsonString.split("\n");
        lines = FastJsonUtil.replaceFunctionQuote(lines);
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            stringBuilder.append(line + "\n");
        }
        return stringBuilder.toString();
    }

    public static String[] replaceFunctionQuote(String[] lines) {
        boolean function = false;
        boolean immediately = false;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!function && line.contains("\"function")) {
                function = true;
                line = line.replaceAll("\"function", "function");
            }
            if (function && line.contains("}\"")) {
                function = false;
                line = line.replaceAll("\\}\"", "\\}");
            }
            if (!immediately && line.contains("\"(function")) {
                immediately = true;
                line = line.replaceAll("\"\\(function", "\\(function");
            }
            if (immediately && line.contains("})()\"")) {
                immediately = false;
                line = line.replaceAll("\\}\\)\\(\\)\"", "\\}\\)\\(\\)");
            }
            lines[i] = line;
        }
        return lines;
    }

    public static <T extends Option> T fromJSON(String json, Class<T> type) {
        return (T)((Option)JSON.parseObject((String)json, type));
    }

    public static Option fromJSON(String json) {
        Option option = (Option)JSON.parseObject((String)json, Option.class);
        return option;
    }

    public static void print(Object object) {
        System.out.println(FastJsonUtil.format(object));
    }

    public static void printPretty(Object object) {
        System.out.println(FastJsonUtil.prettyFormat(object));
    }
}

