/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.config;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.reger.dubbo.annotation.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationBean
extends com.alibaba.dubbo.config.spring.AnnotationBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AnnotationBean.class);
    private final Map<String, ReferenceBean<?>> referenceSelfConfigs;
    private final Set<ServiceConfig<?>> serviceConfigs;
    private ApplicationContext applicationContext;
    private String[] annotationPackages;

    public AnnotationBean() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field referenceField = com.alibaba.dubbo.config.spring.AnnotationBean.class.getDeclaredField("referenceConfigs");
        if (!referenceField.isAccessible()) {
            referenceField.setAccessible(true);
        }
        this.referenceSelfConfigs = (Map)referenceField.get((Object)this);
        referenceField.setAccessible(false);
        Field serviceField = com.alibaba.dubbo.config.spring.AnnotationBean.class.getDeclaredField("serviceConfigs");
        if (!serviceField.isAccessible()) {
            serviceField.setAccessible(true);
        }
        this.serviceConfigs = (Set)serviceField.get((Object)this);
        serviceField.setAccessible(false);
    }

    public void setPackage(String annotationPackage) {
        super.setPackage(annotationPackage);
        this.annotationPackages = annotationPackage == null || annotationPackage.length() == 0 ? null : Constants.COMMA_SPLIT_PATTERN.split(annotationPackage);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        super.setApplicationContext(applicationContext);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.isMatchPackage(bean)) {
            return bean;
        }
        Class<?> clazs = this.getOriginalClass(bean);
        Service service = clazs.getAnnotation(Service.class);
        if (service != null) {
            if (Void.TYPE.equals(service.interfaceClass()) && "".equals(service.interfaceName())) {
                Object[] interfaces = clazs.getInterfaces();
                Assert.notEmpty((Object[])interfaces, (String)("Failed to export remote service class " + clazs.getName() + ", cause: The @Service undefined interfaceClass or interfaceName, and the service class unimplemented any interfaces."));
                for (Object interfaceClass : interfaces) {
                    this.export(bean, service, (Class<?>)interfaceClass);
                    logger.debug("dubbo\u6210\u529f\u5c06{}\u4ee5{}\u65b9\u5f0f\u5bfc\u51fa", (Object)beanName, interfaceClass);
                }
            } else {
                this.export(bean, service, null);
            }
        }
        return bean;
    }

    private void export(Object bean, Service service, Class<?> interfaceClass) {
        ServiceBean serviceConfig = new ServiceBean(service);
        if (interfaceClass != null) {
            serviceConfig.setInterface(interfaceClass);
        }
        if (this.applicationContext != null) {
            serviceConfig.setApplicationContext(this.applicationContext);
            if (service.registry() != null && service.registry().length > 0) {
                serviceConfig.setRegistries(this.getRegistryConfigs(service.registry()));
            }
            if (service.provider() != null && service.provider().length() > 0) {
                serviceConfig.setProvider(this.getBean(service.provider(), ProviderConfig.class));
            }
            if (service.monitor() != null && service.monitor().length() > 0) {
                serviceConfig.setMonitor(this.getBean(service.monitor(), MonitorConfig.class));
            }
            if (service.application() != null && service.application().length() > 0) {
                serviceConfig.setApplication(this.getBean(service.application(), ApplicationConfig.class));
            }
            if (service.module() != null && service.module().length() > 0) {
                serviceConfig.setModule(this.getBean(service.module(), ModuleConfig.class));
            }
            if (service.provider() != null && service.provider().length() > 0) {
                serviceConfig.setProvider(this.getBean(service.provider(), ProviderConfig.class));
            }
            if (service.protocol() != null && service.protocol().length > 0) {
                serviceConfig.setProtocols(this.getProtocolConfigs(service.protocol()));
            }
            this.InitializingBean((InitializingBean)serviceConfig);
        }
        serviceConfig.setRef(bean);
        this.serviceConfigs.add((ServiceConfig<?>)serviceConfig);
        serviceConfig.export();
    }

    private void InitializingBean(InitializingBean bean) {
        try {
            bean.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private List<ProtocolConfig> getProtocolConfigs(String[] protocols) {
        ArrayList<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
        for (String protocolId : protocols) {
            if (protocolId == null || protocolId.length() <= 0) continue;
            protocolConfigs.add(this.getBean(protocolId, ProtocolConfig.class));
        }
        return protocolConfigs;
    }

    private List<RegistryConfig> getRegistryConfigs(String[] registrys) {
        ArrayList<RegistryConfig> registryConfigs = new ArrayList<RegistryConfig>();
        for (String registryId : registrys) {
            if (registryId == null || registryId.length() <= 0) continue;
            registryConfigs.add(this.getBean(registryId, RegistryConfig.class));
        }
        return registryConfigs;
    }

    private <T> T getBean(String name, Class<T> clazz) {
        return (T)this.applicationContext.getBean(name, clazz);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!this.isMatchPackage(bean)) {
            return bean;
        }
        this.buildMethod(bean);
        this.buildField(bean);
        return bean;
    }

    private void buildField(final Object bean) {
        ReflectionUtils.doWithFields(this.getOriginalClass(bean), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    Inject inject = field.getAnnotation(Inject.class);
                    Class<?> type = field.getType();
                    if (inject != null) {
                        field.set(bean, AnnotationBean.this.refer(inject, type));
                    } else {
                        Reference reference = field.getAnnotation(Reference.class);
                        if (reference != null) {
                            field.set(bean, AnnotationBean.this.refer(reference, type));
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("Failed to init remote service reference at filed {} in class {}, cause: {}", new Object[]{field.getName(), AnnotationBean.this.getOriginalClass(bean).getName(), e.getMessage(), e});
                    throw new BeanInitializationException("Failed to init remote service reference at filed " + field.getName() + " in class " + bean.getClass().getName(), e);
                }
            }
        });
    }

    private void buildMethod(final Object bean) {
        ReflectionUtils.doWithMethods(this.getOriginalClass(bean), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                    try {
                        Inject inject = method.getAnnotation(Inject.class);
                        Class<?> type = method.getParameterTypes()[0];
                        if (inject != null) {
                            method.invoke(bean, AnnotationBean.this.refer(inject, type));
                        } else {
                            Reference reference = method.getAnnotation(Reference.class);
                            if (reference != null) {
                                method.invoke(bean, AnnotationBean.this.refer(reference, type));
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.error("Failed to init remote service reference at method {} in class {}, cause: {}", new Object[]{method.getName(), AnnotationBean.this.getOriginalClass(bean).getName(), e.getMessage(), e});
                        throw new BeanInitializationException("Failed to init remote service reference at method " + method.getName() + " in class " + bean.getClass().getName(), e);
                    }
                }
            }
        });
    }

    protected Object refer(Inject inject, Class<?> referenceClass) {
        try {
            String beanName = inject.name().trim();
            if (beanName.isEmpty()) {
                Object obj = this.applicationContext.getBean(referenceClass);
                if (obj != null) {
                    return obj;
                }
            } else {
                Object obj = this.getBean(beanName, referenceClass);
                if (obj != null) {
                    return obj;
                }
            }
        }
        catch (BeansException e) {
            logger.debug("\u4ecespring\u4e0a\u4e0b\u6587\u65e0\u6cd5\u6b63\u786e\u6ce8\u5165{}\uff0c\u5c06\u4ecedubbo\u4e2d\u52a0\u8f7d  , Error Message:{}", new Object[]{referenceClass, e.getMessage(), e});
        }
        return this.refer(inject.value(), referenceClass);
    }

    protected Object refer(Reference reference, Class<?> referenceClass) {
        String interfaceName;
        if (!"".equals(reference.interfaceName())) {
            interfaceName = reference.interfaceName();
        } else if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (referenceClass.isInterface()) {
            interfaceName = referenceClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the property type " + referenceClass.getName() + " is not a interface.");
        }
        String key = String.format("%s/%s:%s", reference.group(), interfaceName, reference.version());
        if (!this.referenceSelfConfigs.containsKey(key)) {
            this.referenceSelfConfigs.put(key, this.initReferenceConfig(reference, referenceClass));
        }
        return this.referenceSelfConfigs.get(key).get();
    }

    private ReferenceBean<?> initReferenceConfig(Reference reference, Class<?> referenceClass) {
        ReferenceBean referenceConfig = new ReferenceBean(reference);
        if (Void.TYPE.equals(reference.interfaceClass()) && "".equals(reference.interfaceName()) && referenceClass.isInterface()) {
            referenceConfig.setInterface(referenceClass);
        }
        if (this.applicationContext != null) {
            referenceConfig.setApplicationContext(this.applicationContext);
            if (reference.registry() != null && reference.registry().length > 0) {
                referenceConfig.setRegistries(this.getRegistryConfigs(reference.registry()));
            }
            if (reference.consumer() != null && reference.consumer().length() > 0) {
                referenceConfig.setConsumer(this.getBean(reference.consumer(), ConsumerConfig.class));
            }
            if (reference.monitor() != null && reference.monitor().length() > 0) {
                referenceConfig.setMonitor(this.getBean(reference.monitor(), MonitorConfig.class));
            }
            if (reference.application() != null && reference.application().length() > 0) {
                referenceConfig.setApplication(this.getBean(reference.application(), ApplicationConfig.class));
            }
            if (reference.module() != null && reference.module().length() > 0) {
                referenceConfig.setModule(this.getBean(reference.module(), ModuleConfig.class));
            }
            if (reference.consumer() != null && reference.consumer().length() > 0) {
                referenceConfig.setConsumer(this.getBean(reference.consumer(), ConsumerConfig.class));
            }
            this.InitializingBean((InitializingBean)referenceConfig);
        }
        return referenceConfig;
    }

    protected boolean isMatchPackage(Object bean) {
        if (this.annotationPackages == null || this.annotationPackages.length == 0) {
            return true;
        }
        String beanClassName = this.getOriginalClass(bean).getName();
        for (String pkg : this.annotationPackages) {
            if (!beanClassName.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private Class<?> getOriginalClass(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            return AopUtils.getTargetClass((Object)bean);
        }
        return bean.getClass();
    }

    public void destroy() throws Exception {
        logger.info("dubbo\u5f00\u59cb\u5173\u95ed....");
        super.destroy();
        ProtocolConfig.destroyAll();
        RegistryConfig.destroyAll();
    }
}

