/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.raw.RawObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class RawAccessor
implements Accessor {
    private Format parentFormat;
    private Accessor superAccessor;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private boolean isCompositeKey;

    RawAccessor(Format parentFormat, Accessor superAccessor, FieldInfo priKeyField, List<FieldInfo> secKeyFields, List<FieldInfo> nonKeyFields) {
        this.parentFormat = parentFormat;
        this.superAccessor = superAccessor;
        this.priKeyField = priKeyField;
        this.secKeyFields = secKeyFields;
        this.nonKeyFields = nonKeyFields;
    }

    RawAccessor(Format parentFormat, List<FieldInfo> nonKeyFields) {
        this.parentFormat = parentFormat;
        this.nonKeyFields = nonKeyFields;
        this.secKeyFields = Collections.emptyList();
        this.isCompositeKey = true;
    }

    @Override
    public Object newInstance() {
        RawObject superObject = this.superAccessor != null ? (RawObject)this.superAccessor.newInstance() : null;
        return new RawObject(this.parentFormat, new HashMap<String, Object>(), superObject);
    }

    @Override
    public Object newArray(int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object o) {
        if (this.priKeyField != null) {
            Object val = this.getValue(o, this.priKeyField);
            Format format = this.priKeyField.getType();
            if (format.isPrimitive()) {
                return ((Number)val).longValue() == 0L;
            }
            return val == null;
        }
        if (this.superAccessor != null) {
            return this.superAccessor.isPriKeyFieldNullOrZero(this.getSuper(o));
        }
        throw new IllegalStateException("No primary key field");
    }

    @Override
    public void writePriKeyField(Object o, EntityOutput output) {
        if (this.priKeyField != null) {
            Object val = this.getValue(o, this.priKeyField);
            Format format = this.priKeyField.getType();
            output.writeKeyObject(val, format);
        } else if (this.superAccessor != null) {
            this.superAccessor.writePriKeyField(this.getSuper(o), output);
        } else {
            throw new IllegalStateException("No primary key field");
        }
    }

    @Override
    public void readPriKeyField(Object o, EntityInput input) {
        if (this.priKeyField != null) {
            Format format = this.priKeyField.getType();
            Object val = input.readKeyObject(format);
            this.setValue(o, this.priKeyField, val);
        } else if (this.superAccessor != null) {
            this.superAccessor.readPriKeyField(this.getSuper(o), input);
        } else {
            throw new IllegalStateException("No primary key field");
        }
    }

    @Override
    public void writeSecKeyFields(Object o, EntityOutput output) {
        if (this.priKeyField != null && !this.priKeyField.getType().isPrimitive()) {
            output.registerPriKeyObject(this.getValue(o, this.priKeyField));
        }
        if (this.superAccessor != null) {
            this.superAccessor.writeSecKeyFields(this.getSuper(o), output);
        }
        for (int i = 0; i < this.secKeyFields.size(); ++i) {
            this.writeField(o, this.secKeyFields.get(i), output);
        }
    }

    @Override
    public void readSecKeyFields(Object o, EntityInput input, int startField, int endField, int superLevel) {
        if (this.priKeyField != null && !this.priKeyField.getType().isPrimitive()) {
            input.registerPriKeyObject(this.getValue(o, this.priKeyField));
        }
        if (superLevel != 0 && this.superAccessor != null) {
            this.superAccessor.readSecKeyFields(this.getSuper(o), input, startField, endField, superLevel - 1);
        } else if (superLevel > 0) {
            throw new IllegalStateException("Super class does not exist");
        }
        if (superLevel <= 0) {
            for (int i = startField; i <= endField && i < this.secKeyFields.size(); ++i) {
                this.readField(o, this.secKeyFields.get(i), input);
            }
        }
    }

    @Override
    public void writeNonKeyFields(Object o, EntityOutput output) {
        if (this.superAccessor != null) {
            this.superAccessor.writeNonKeyFields(this.getSuper(o), output);
        }
        for (int i = 0; i < this.nonKeyFields.size(); ++i) {
            this.writeField(o, this.nonKeyFields.get(i), output);
        }
    }

    @Override
    public void readNonKeyFields(Object o, EntityInput input, int startField, int endField, int superLevel) {
        if (superLevel != 0 && this.superAccessor != null) {
            this.superAccessor.readNonKeyFields(this.getSuper(o), input, startField, endField, superLevel - 1);
        } else if (superLevel > 0) {
            throw new IllegalStateException("Super class does not exist");
        }
        if (superLevel <= 0) {
            for (int i = startField; i <= endField && i < this.nonKeyFields.size(); ++i) {
                this.readField(o, this.nonKeyFields.get(i), input);
            }
        }
    }

    @Override
    public Object getField(Object o, int field, int superLevel, boolean isSecField) {
        if (superLevel > 0) {
            return this.superAccessor.getField(this.getSuper(o), field, superLevel - 1, isSecField);
        }
        FieldInfo fld = isSecField ? this.secKeyFields.get(field) : this.nonKeyFields.get(field);
        return this.getValue(o, fld);
    }

    @Override
    public void setField(Object o, int field, int superLevel, boolean isSecField, Object value) {
        if (superLevel > 0) {
            this.superAccessor.setField(this.getSuper(o), field, superLevel - 1, isSecField, value);
            return;
        }
        FieldInfo fld = isSecField ? this.secKeyFields.get(field) : this.nonKeyFields.get(field);
        this.setValue(o, fld, value);
    }

    private RawObject getSuper(Object o) {
        return ((RawObject)o).getSuper();
    }

    private Object getValue(Object o, FieldInfo field) {
        return ((RawObject)o).getValues().get(field.getName());
    }

    private void setValue(Object o, FieldInfo field, Object val) {
        ((RawObject)o).getValues().put(field.getName(), val);
    }

    private void writeField(Object o, FieldInfo field, EntityOutput output) {
        Object val = this.getValue(o, field);
        Format format = field.getType();
        if (this.isCompositeKey || format.isPrimitive()) {
            output.writeKeyObject(val, format);
        } else {
            output.writeObject(val, format);
        }
    }

    private void readField(Object o, FieldInfo field, EntityInput input) {
        Format format = field.getType();
        Object val = this.isCompositeKey || format.isPrimitive() ? input.readKeyObject(format) : input.readObject();
        this.setValue(o, field, val);
    }
}

