/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.AbstractInput;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.raw.RawObject;
import java.math.BigInteger;
import java.util.IdentityHashMap;

abstract class RawAbstractInput
extends AbstractInput {
    private IdentityHashMap converted;

    RawAbstractInput(Catalog catalog, boolean rawAccess, IdentityHashMap converted) {
        super(catalog, rawAccess);
        this.converted = converted;
    }

    @Override
    public Object readObject() {
        return this.readNext();
    }

    @Override
    public Object readKeyObject(Format format) {
        return this.readNext();
    }

    @Override
    public void registerPriKeyObject(Object o) {
    }

    @Override
    public int readArrayLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readEnumConstant(String[] names) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipField(Format declaredFormat) {
    }

    abstract Object readNext();

    Object checkAndConvert(Object o, Format declaredFormat) {
        if (o == null) {
            if (declaredFormat.isPrimitive()) {
                throw new IllegalArgumentException("A primitive type may not be null or missing: " + declaredFormat.getClassName());
            }
        } else if (declaredFormat.isSimple()) {
            if (declaredFormat.isPrimitive()) {
                if (o.getClass() != declaredFormat.getWrapperFormat().getType()) {
                    throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " must be the wrapper class for a primitive type: " + declaredFormat.getClassName());
                }
            } else if (o.getClass() != declaredFormat.getType()) {
                throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " must be the declared class for a simple type: " + declaredFormat.getClassName());
            }
        } else {
            if (o instanceof RawObject) {
                Object o2 = null;
                if (!this.rawAccess) {
                    if (this.converted != null) {
                        o2 = this.converted.get(o);
                    } else {
                        this.converted = new IdentityHashMap();
                    }
                }
                if (o2 != null) {
                    o = o2;
                } else if (!this.rawAccess) {
                    o = this.catalog.convertRawObject((RawObject)o, this.converted);
                }
            } else if (!SimpleCatalog.isSimpleType(o.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " must be RawObject a simple type");
            }
            if (this.rawAccess) {
                RawAbstractInput.checkRawType(this.catalog, o, declaredFormat);
            } else if (!declaredFormat.getType().isAssignableFrom(o.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " is not assignable to type: " + declaredFormat.getClassName());
            }
        }
        return o;
    }

    static Format checkRawType(Catalog catalog, Object o, Format declaredFormat) {
        Format format;
        assert (declaredFormat != null);
        if (o instanceof RawObject) {
            format = (Format)((RawObject)o).getType();
        } else {
            format = catalog.getFormat(o.getClass(), false);
            if (!format.isSimple() || format.isEnum()) {
                throw new IllegalArgumentException("Not a RawObject or a non-enum simple type: " + format.getClassName());
            }
        }
        if (!format.isAssignableTo(declaredFormat)) {
            throw new IllegalArgumentException("Not a subtype of the field's declared class " + declaredFormat.getClassName() + ": " + format.getClassName());
        }
        if (!format.isCurrentVersion()) {
            throw new IllegalArgumentException("Raw type version is not current.  Class: " + format.getClassName() + " Version: " + format.getVersion());
        }
        Format proxiedFormat = format.getProxiedFormat();
        if (proxiedFormat != null) {
            format = proxiedFormat;
        }
        return format;
    }

    @Override
    public String readString() {
        return (String)this.readNext();
    }

    @Override
    public char readChar() {
        return ((Character)this.readNext()).charValue();
    }

    @Override
    public boolean readBoolean() {
        return (Boolean)this.readNext();
    }

    @Override
    public byte readByte() {
        return (Byte)this.readNext();
    }

    @Override
    public short readShort() {
        return (Short)this.readNext();
    }

    @Override
    public int readInt() {
        return (Integer)this.readNext();
    }

    @Override
    public long readLong() {
        return (Long)this.readNext();
    }

    @Override
    public float readSortedFloat() {
        return ((Float)this.readNext()).floatValue();
    }

    @Override
    public double readSortedDouble() {
        return (Double)this.readNext();
    }

    @Override
    public BigInteger readBigInteger() {
        return (BigInteger)this.readNext();
    }
}

