/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.RawArrayInput;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectArrayFormat
extends Format {
    private static final long serialVersionUID = 4317004346690441892L;
    private Format componentFormat;
    private int nDimensions;
    private transient Format useComponentFormat;

    ObjectArrayFormat(Class type) {
        super(type);
        String name = this.getClassName();
        this.nDimensions = 0;
        while (name.charAt(this.nDimensions) == '[') {
            ++this.nDimensions;
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return this.nDimensions;
    }

    @Override
    public Format getComponentType() {
        return this.useComponentFormat != null ? this.useComponentFormat : this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        Class<?> cls = this.getType().getComponentType();
        catalog.createFormat(cls, newFormats);
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        if (this.componentFormat == null) {
            Class<?> cls = this.getType().getComponentType();
            this.componentFormat = catalog.getFormat(cls.getName());
        }
        this.useComponentFormat = this.componentFormat.getLatestVersion();
    }

    @Override
    boolean isAssignableTo(Format format) {
        if (super.isAssignableTo(format)) {
            return true;
        }
        if (format instanceof ObjectArrayFormat) {
            ObjectArrayFormat other = (ObjectArrayFormat)format;
            if (this.useComponentFormat.isAssignableTo(other.useComponentFormat)) {
                return true;
            }
        }
        return false;
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        int len = input.readArrayLength();
        if (rawAccess) {
            return new RawObject((RawType)this, new Object[len]);
        }
        return this.useComponentFormat.newArray(len);
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        Object[] a = rawAccess ? ((RawObject)o).getElements() : (Object[])o;
        for (int i = 0; i < a.length; ++i) {
            a[i] = input.readObject();
        }
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        Object[] a = rawAccess ? ((RawObject)o).getElements() : (Object[])o;
        output.writeArrayLength(a.length);
        for (int i = 0; i < a.length; ++i) {
            output.writeObject(a[i], this.useComponentFormat);
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        RawArrayInput input = new RawArrayInput(catalog, rawAccess, converted, rawObject, this.useComponentFormat);
        Object a = this.newInstance(input, rawAccess);
        converted.put(rawObject, a);
        return this.readObject(a, input, rawAccess);
    }

    @Override
    void skipContents(RecordInput input) {
        int len = input.readPackedInt();
        for (int i = 0; i < len; ++i) {
            input.skipField(this.useComponentFormat);
        }
    }

    @Override
    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) {
        int len = input.readPackedInt();
        for (int i = 0; i < len; ++i) {
            KeyLocation loc = input.getKeyLocation(this.useComponentFormat);
            if (loc == null) {
                throw new IllegalArgumentException("Secondary key values in array may not be null");
            }
            if (loc.format != this.useComponentFormat) {
                throw new IllegalStateException(this.useComponentFormat.getClassName());
            }
            int off1 = loc.input.getBufferOffset();
            this.useComponentFormat.skipContents(loc.input);
            int off2 = loc.input.getBufferOffset();
            DatabaseEntry entry = new DatabaseEntry(loc.input.getBufferBytes(), off1, off2 - off1);
            results.add(entry);
        }
    }

    @Override
    boolean evolve(Format newFormat, Evolver evolver) {
        Format latest = this.componentFormat.getLatestVersion();
        if (latest != this.componentFormat && !latest.getClassName().equals(this.componentFormat.getClassName())) {
            evolver.useEvolvedFormat(this, newFormat, newFormat);
        } else {
            evolver.useOldFormat(this, newFormat);
        }
        return true;
    }
}

