/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ScavengerFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.util.DbDump;
import com.sleepycat.je.utilint.BitMap;
import com.sleepycat.je.utilint.DbLsn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DbScavenger
extends DbDump {
    private static final int FLUSH_INTERVAL = 100;
    private int readBufferSize;
    private EnvironmentImpl envImpl;
    private BitMap committedTxnIdsSeen;
    private BitMap nodeIdsSeen;
    private Map<Integer, String> dbIdToName;
    private Map<Integer, Boolean> dbIdToDupSort;
    private Map<Integer, PrintStream> dbIdToOutputStream;
    private boolean dumpCorruptedBounds = false;
    private int flushCounter = 0;
    private long lastTime;

    public DbScavenger(Environment env, String outputDirectory, boolean formatUsingPrintable, boolean doAggressiveScavengerRun, boolean verbose) {
        super(env, null, null, formatUsingPrintable);
        this.doAggressiveScavengerRun = doAggressiveScavengerRun;
        this.dbIdToName = new HashMap<Integer, String>();
        this.dbIdToDupSort = new HashMap<Integer, Boolean>();
        this.dbIdToOutputStream = new HashMap<Integer, PrintStream>();
        this.verbose = verbose;
        this.outputDirectory = outputDirectory;
    }

    public void setDumpCorruptedBounds(boolean dumpCorruptedBounds) {
        this.dumpCorruptedBounds = dumpCorruptedBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() throws IOException, DatabaseException {
        this.openEnv(false);
        this.envImpl = DbInternal.envGetEnvironmentImpl(this.env);
        DbConfigManager cm = this.envImpl.getConfigManager();
        try {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        catch (DatabaseException DBE) {
            this.readBufferSize = 8192;
        }
        LastFileReader reader = new LastFileReader(this.envImpl, this.readBufferSize);
        while (reader.readNextEntry()) {
        }
        long lastUsedLsn = reader.getLastValidLsn();
        long nextAvailableLsn = reader.getEndOfLog();
        this.envImpl.getFileManager().setLastPosition(nextAvailableLsn, lastUsedLsn, reader.getPrevOffset());
        try {
            if (this.verbose) {
                System.out.println("Pass 1: " + new Date());
            }
            this.scavengeDbTree(lastUsedLsn, nextAvailableLsn);
            if (this.verbose) {
                System.out.println("Pass 2: " + new Date());
            }
            this.scavenge(lastUsedLsn, nextAvailableLsn);
            if (this.verbose) {
                System.out.println("End: " + new Date());
            }
        }
        finally {
            this.closeOutputStreams();
        }
    }

    private void scavengeDbTree(long lastUsedLsn, long nextAvailableLsn) throws IOException, DatabaseException {
        this.committedTxnIdsSeen = new BitMap();
        this.nodeIdsSeen = new BitMap();
        ScavengerFileReader scavengerReader = new ScavengerFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, -1L, nextAvailableLsn){

            @Override
            protected void processEntryCallback(LogEntry entry, LogEntryType entryType) throws DatabaseException {
                DbScavenger.this.processDbTreeEntry(entry, entryType);
            }
        };
        scavengerReader.setTargetType(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_MAPLN);
        scavengerReader.setTargetType(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_NAMELN);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_COMMIT);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_ABORT);
        this.lastTime = System.currentTimeMillis();
        long fileNum = -1L;
        while (scavengerReader.readNextEntry()) {
            fileNum = this.reportProgress(fileNum, scavengerReader.getLastLsn());
        }
    }

    private long reportProgress(long fileNum, long lastLsn) {
        long currentFile = DbLsn.getFileNumber(lastLsn);
        if (this.verbose && currentFile != fileNum) {
            long now = System.currentTimeMillis();
            System.out.println("processing file " + FileManager.getFileName(currentFile, ".jdb  ") + (now - this.lastTime) + " ms");
            this.lastTime = now;
        }
        return currentFile;
    }

    private boolean checkProcessEntry(LogEntry entry, LogEntryType entryType, boolean pass2) {
        boolean isTransactional = entryType.isTransactional();
        if (isTransactional) {
            long txnId = entry.getTransactionId();
            if (entryType.equals(LogEntryType.LOG_TXN_COMMIT)) {
                this.committedTxnIdsSeen.set(txnId);
                return false;
            }
            if (entryType.equals(LogEntryType.LOG_TXN_ABORT)) {
                return false;
            }
            if (!this.committedTxnIdsSeen.get(txnId)) {
                return false;
            }
        }
        if (entry instanceof LNLogEntry) {
            boolean isDelDupLN;
            LNLogEntry lnEntry = (LNLogEntry)entry;
            LN ln = lnEntry.getLN();
            long nodeId = ln.getNodeId();
            boolean bl = isDelDupLN = entryType.equals(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL) || entryType.equals(LogEntryType.LOG_DEL_DUPLN);
            if (pass2 && this.doAggressiveScavengerRun) {
                return !isDelDupLN;
            }
            if (this.nodeIdsSeen.get(nodeId)) {
                return false;
            }
            this.nodeIdsSeen.set(nodeId);
            return !isDelDupLN;
        }
        return false;
    }

    private void processDbTreeEntry(LogEntry entry, LogEntryType entryType) throws DatabaseException {
        boolean processThisEntry = this.checkProcessEntry(entry, entryType, false);
        if (processThisEntry && entry instanceof LNLogEntry) {
            Integer dbId;
            LNLogEntry lnEntry = (LNLogEntry)entry;
            LN ln = lnEntry.getLN();
            if (ln instanceof NameLN) {
                String name = new String(lnEntry.getKey());
                dbId = ((NameLN)ln).getId().getId();
                if (this.dbIdToName.containsKey(dbId) && !this.dbIdToName.get(dbId).equals(name)) {
                    throw new DatabaseException("Already name mapped for dbId: " + dbId + " changed from " + this.dbIdToName.get(dbId) + " to " + name);
                }
                this.dbIdToName.put(dbId, name);
            }
            if (ln instanceof MapLN) {
                DatabaseImpl db = ((MapLN)ln).getDatabase();
                dbId = db.getId().getId();
                Boolean dupSort = db.getSortedDuplicates();
                if (this.dbIdToDupSort.containsKey(dbId)) {
                    throw new DatabaseException("Already saw dupSort entry for dbId: " + dbId);
                }
                this.dbIdToDupSort.put(dbId, dupSort);
            }
        }
    }

    private void scavenge(long lastUsedLsn, long nextAvailableLsn) throws IOException, DatabaseException {
        ScavengerFileReader scavengerReader = new ScavengerFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, -1L, nextAvailableLsn){

            @Override
            protected void processEntryCallback(LogEntry entry, LogEntryType entryType) throws DatabaseException {
                DbScavenger.this.processRegularEntry(entry, entryType);
            }
        };
        scavengerReader.setTargetType(LogEntryType.LOG_LN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_LN);
        scavengerReader.setTargetType(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_DEL_DUPLN);
        scavengerReader.setDumpCorruptedBounds(this.dumpCorruptedBounds);
        long progressFileNum = -1L;
        while (scavengerReader.readNextEntry()) {
            progressFileNum = this.reportProgress(progressFileNum, scavengerReader.getLastLsn());
        }
    }

    private void processRegularEntry(LogEntry entry, LogEntryType entryType) throws DatabaseException {
        boolean processThisEntry = this.checkProcessEntry(entry, entryType, true);
        if (processThisEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            Integer dbId = lnEntry.getDbId().getId();
            PrintStream out = this.getOutputStream(dbId);
            LN ln = lnEntry.getLN();
            byte[] keyData = lnEntry.getKey();
            byte[] data = ln.getData();
            if (data != null) {
                this.dumpOne(out, keyData, this.formatUsingPrintable);
                this.dumpOne(out, data, this.formatUsingPrintable);
                if (++this.flushCounter % 100 == 0) {
                    out.flush();
                    this.flushCounter = 0;
                }
            }
        }
    }

    private PrintStream getOutputStream(Integer dbId) throws DatabaseException {
        try {
            PrintStream ret = this.dbIdToOutputStream.get(dbId);
            if (ret != null) {
                return ret;
            }
            String name = this.dbIdToName.get(dbId);
            if (name == null) {
                name = "db" + dbId;
            }
            File file = new File(this.outputDirectory, name + ".dump");
            ret = new PrintStream(new FileOutputStream(file), false);
            this.dbIdToOutputStream.put(dbId, ret);
            Boolean dupSort = this.dbIdToDupSort.get(dbId);
            if (dupSort == null) {
                dupSort = false;
            }
            this.printHeader(ret, dupSort, this.formatUsingPrintable);
            return ret;
        }
        catch (IOException IOE) {
            throw new DatabaseException(IOE);
        }
    }

    private void closeOutputStreams() {
        for (PrintStream s : this.dbIdToOutputStream.values()) {
            s.println("DATA=END");
            s.close();
        }
    }
}

