/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.cleaner.VerifyUtils;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;

public class DbRunAction {
    private static final int BATCH_CLEAN = 1;
    private static final int COMPRESS = 2;
    private static final int EVICT = 3;
    private static final int CHECKPOINT = 4;
    private static final int REMOVEDB = 5;
    private static final int REMOVEDB_AND_CLEAN = 6;
    private static final int ACTIVATE_CLEANER_THREADS = 7;
    private static final int VERIFY_UTILIZATION = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        long recoveryStart = 0L;
        long actionStart = 0L;
        long actionEnd = 0L;
        try {
            int whichArg = 0;
            if (argv.length == 0) {
                DbRunAction.usage();
                System.exit(1);
            }
            String dbName = null;
            int doAction = 0;
            String envHome = ".";
            boolean readOnly = false;
            boolean printStats = false;
            while (whichArg < argv.length) {
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = CmdUtil.getArg(argv, ++whichArg);
                } else if (nextArg.equals("-a")) {
                    String action;
                    if ((action = CmdUtil.getArg(argv, ++whichArg)).equalsIgnoreCase("batchClean")) {
                        doAction = 1;
                    } else if (action.equalsIgnoreCase("compress")) {
                        doAction = 2;
                    } else if (action.equalsIgnoreCase("checkpoint")) {
                        doAction = 4;
                    } else if (action.equalsIgnoreCase("evict")) {
                        doAction = 3;
                    } else if (action.equalsIgnoreCase("removedb")) {
                        doAction = 5;
                    } else if (action.equalsIgnoreCase("removedbAndClean")) {
                        doAction = 6;
                    } else if (action.equalsIgnoreCase("activateCleaner")) {
                        doAction = 7;
                    } else if (action.equalsIgnoreCase("verifyUtilization")) {
                        doAction = 8;
                    } else {
                        DbRunAction.usage();
                        System.exit(1);
                    }
                } else if (nextArg.equals("-ro")) {
                    readOnly = true;
                } else if (nextArg.equals("-s")) {
                    dbName = argv[++whichArg];
                } else if (nextArg.equals("-stats")) {
                    printStats = true;
                } else {
                    throw new IllegalArgumentException(nextArg + " is not a supported option.");
                }
                ++whichArg;
            }
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setConfigParam(EnvironmentParams.JE_LOGGING_CONSOLE.getName(), "true");
            if (readOnly) {
                envConfig.setConfigParam(EnvironmentParams.JE_LOGGING_DBLOG.getName(), "false");
                envConfig.setReadOnly(true);
            }
            if (doAction == 3) {
                envConfig.setConfigParam(EnvironmentParams.ENV_RUN_EVICTOR.getName(), "false");
                envConfig.setConfigParam(EnvironmentParams.EVICTOR_CRITICAL_PERCENTAGE.getName(), "1000");
            }
            recoveryStart = System.currentTimeMillis();
            Environment env = new Environment(new File(envHome), envConfig);
            CheckpointConfig forceConfig = new CheckpointConfig();
            forceConfig.setForce(true);
            StatsPrinter statsPrinter = null;
            if (printStats) {
                statsPrinter = new StatsPrinter(env);
                statsPrinter.start();
            }
            boolean promptForShutdown = false;
            actionStart = System.currentTimeMillis();
            switch (doAction) {
                case 1: {
                    int nFiles;
                    do {
                        nFiles = env.cleanLog();
                        System.out.println("Files cleaned: " + nFiles);
                    } while (nFiles != 0);
                    env.checkpoint(forceConfig);
                    break;
                }
                case 2: {
                    env.compress();
                    break;
                }
                case 4: {
                    env.checkpoint(forceConfig);
                    break;
                }
                case 3: {
                    DbRunAction.preload(env, dbName);
                    break;
                }
                case 5: {
                    DbRunAction.removeAndClean(env, dbName, false);
                    break;
                }
                case 6: {
                    DbRunAction.removeAndClean(env, dbName, true);
                    break;
                }
                case 7: {
                    EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl(env);
                    envImpl.getCleaner().wakeup();
                    promptForShutdown = true;
                    break;
                }
                case 8: {
                    EnvironmentImpl envImpl2 = DbInternal.envGetEnvironmentImpl(env);
                    VerifyUtils.verifyUtilization(envImpl2, true, true, true);
                }
            }
            actionEnd = System.currentTimeMillis();
            if (promptForShutdown) {
                DbRunAction.waitForShutdown();
            }
            if (statsPrinter != null) {
                statsPrinter.interrupt();
                statsPrinter.join();
            }
            env.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbRunAction.usage();
            System.exit(1);
        }
        finally {
            DecimalFormat f = new DecimalFormat();
            f.setMaximumFractionDigits(2);
            long recoveryDuration = actionStart - recoveryStart;
            System.out.println("\nrecovery time = " + f.format(recoveryDuration) + " millis " + f.format((double)recoveryDuration / 60000.0) + " minutes");
            long actionDuration = actionEnd - actionStart;
            System.out.println("action time = " + f.format(actionDuration) + " millis " + f.format(actionDuration / 60000L) + " minutes");
        }
    }

    private static void removeAndClean(Environment env, String name, boolean doCleaning) throws DatabaseException {
        Transaction txn = null;
        CheckpointConfig force = new CheckpointConfig();
        force.setForce(true);
        long a = System.currentTimeMillis();
        env.removeDatabase(txn, name);
        long c = System.currentTimeMillis();
        int cleanedCount = 0;
        if (doCleaning) {
            while (env.cleanLog() > 0) {
                ++cleanedCount;
            }
        }
        long d = System.currentTimeMillis();
        System.out.println("cleanedCount=" + cleanedCount);
        long e = 0L;
        long f = 0L;
        if (cleanedCount > 0) {
            e = System.currentTimeMillis();
            env.checkpoint(force);
            f = System.currentTimeMillis();
        }
        System.out.println("Remove of " + name + " remove: " + DbRunAction.getSecs(a, c) + " clean: " + DbRunAction.getSecs(c, d) + " checkpoint: " + DbRunAction.getSecs(e, f));
    }

    private static String getSecs(long start, long end) {
        return (end - start) / 1000L + " secs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preload(Environment env, String dbName) throws DatabaseException {
        System.out.println("Preload starting");
        Database db = env.openDatabase(null, dbName, null);
        Cursor cursor = db.openCursor(null, null);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            int count = 0;
            while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                if (++count % 50000 != 0) continue;
                System.out.println(count + "...");
            }
            System.out.println("Preloaded " + count + " records");
        }
        finally {
            cursor.close();
            db.close();
        }
    }

    private static void doEvict(Environment env) throws DatabaseException {
        EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl(env);
        long cacheUsage = envImpl.getMemoryBudget().getCacheMemoryUsage();
        EnvironmentMutableConfig c = new EnvironmentMutableConfig();
        c.setCacheSize(cacheUsage / 2L);
        env.setMutableConfig(c);
        long start = System.currentTimeMillis();
        env.evictMemory();
        long end = System.currentTimeMillis();
        DecimalFormat f = new DecimalFormat();
        f.setMaximumFractionDigits(2);
        System.out.println("evict time=" + f.format(end - start));
    }

    private static void waitForShutdown() throws IOException {
        String val;
        System.out.println("Wait for daemon activity to run. When ready to stop, type (y)");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((val = reader.readLine()) == null || !val.equalsIgnoreCase("y") && !val.equalsIgnoreCase("yes")) {
            System.out.println("Shutdown? (y)");
        }
    }

    private static void usage() {
        System.out.println("Usage: \n " + CmdUtil.getJavaCommand(DbRunAction.class));
        System.out.println("  -h <environment home> ");
        System.out.println("  -a <batchClean|compress|evict|checkpoint|removeDb|removeDbAndClean|activateCleaner|verifyUtilization>");
        System.out.println("  -ro (read-only - defaults to read-write)");
        System.out.println("  -s <dbName> (for removeDb)");
        System.out.println("  -stats (print every 30 seconds)");
    }

    private static class StatsPrinter
    extends Thread {
        private Environment env;

        StatsPrinter(Environment env) {
            this.env = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StatsConfig clearConfig = new StatsConfig();
            clearConfig.setClear(true);
            try {
                while (true) {
                    StatsPrinter statsPrinter = this;
                    synchronized (statsPrinter) {
                        this.wait(30000L);
                    }
                    EnvironmentStats stats = this.env.getStats(clearConfig);
                    System.out.println("\n" + stats + "\n");
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
            }
        }
    }
}

