/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.utilint.DbLsn;

public class DbBackup {
    private EnvironmentImpl envImpl;
    private boolean backupStarted;
    private long lastFileInBackupSet = -1L;
    private boolean envIsReadOnly;

    public DbBackup(Environment env) throws DatabaseException {
        env.checkHandleIsValid();
        this.envImpl = DbInternal.envGetEnvironmentImpl(env);
        FileManager fileManager = this.envImpl.getFileManager();
        this.envIsReadOnly = fileManager.checkEnvHomePermissions(true);
        if (!this.envIsReadOnly && this.envImpl.isReadOnly()) {
            throw new DatabaseException(this.getClass().getName() + " requires a read/write Environment handle");
        }
    }

    public synchronized void startBackup() throws DatabaseException {
        if (this.backupStarted) {
            throw new DatabaseException(this.getClass().getName() + ".startBackup was already called");
        }
        this.backupStarted = true;
        try {
            this.envImpl.getCleaner().setDeleteProhibited();
            FileManager fileManager = this.envImpl.getFileManager();
            if (this.envIsReadOnly) {
                this.lastFileInBackupSet = fileManager.getLastFileNum();
            } else {
                long newFileNum = this.envImpl.forceLogFileFlip();
                this.lastFileInBackupSet = DbLsn.getFileNumber(newFileNum) - 1L;
            }
        }
        catch (DatabaseException e) {
            this.backupStarted = false;
            throw e;
        }
    }

    public synchronized void endBackup() throws DatabaseException {
        this.checkBackupStarted();
        try {
            this.envImpl.getCleaner().clearDeleteProhibited();
        }
        finally {
            this.backupStarted = false;
        }
    }

    public synchronized long getLastFileInBackupSet() throws DatabaseException {
        this.checkBackupStarted();
        return this.lastFileInBackupSet;
    }

    public synchronized String[] getLogFilesInBackupSet() throws DatabaseException {
        this.checkBackupStarted();
        return this.envImpl.getFileManager().listFiles(0L, this.lastFileInBackupSet);
    }

    public synchronized String[] getLogFilesInBackupSet(long lastFileCopiedInPrevBackup) throws DatabaseException {
        this.checkBackupStarted();
        FileManager fileManager = this.envImpl.getFileManager();
        return fileManager.listFiles(lastFileCopiedInPrevBackup + 1L, this.lastFileInBackupSet);
    }

    private void checkBackupStarted() throws DatabaseException {
        if (!this.backupStarted) {
            throw new DatabaseException(this.getClass().getName() + ".startBackup was not called");
        }
    }
}

