/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import java.util.concurrent.locks.ReentrantLock;

public class Latch {
    private JEReentrantLock lock;
    private String name;
    private LatchStats stats = new LatchStats();

    public Latch(String name) {
        this.lock = new JEReentrantLock(EnvironmentImpl.getFairLatches());
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void acquire() throws DatabaseException {
        try {
            if (this.lock.isHeldByCurrentThread()) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.name + " already held");
            }
            if (this.lock.isLocked()) {
                ++this.stats.nAcquiresWithContention;
            } else {
                ++this.stats.nAcquiresNoWaiters;
            }
            this.lock.lock();
            assert (this.noteLatch());
        }
        finally {
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    public boolean acquireNoWait() throws LatchException {
        try {
            if (this.lock.isHeldByCurrentThread()) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.name + " already held");
            }
            boolean ret = this.lock.tryLock();
            if (ret) {
                assert (this.noteLatch());
                ++this.stats.nAcquireNoWaitSuccessful;
            } else {
                ++this.stats.nAcquireNoWaitUnsuccessful;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    public void releaseIfOwner() {
        this.doRelease(false);
    }

    public void release() throws LatchNotHeldException {
        if (this.doRelease(true)) {
            throw new LatchNotHeldException(this.name + " not held");
        }
    }

    private boolean doRelease(boolean checkHeld) {
        try {
            if (!this.lock.isHeldByCurrentThread()) {
                return true;
            }
            this.lock.unlock();
            ++this.stats.nReleases;
            assert (this.unNoteLatch(checkHeld));
        }
        catch (IllegalMonitorStateException IMSE) {
            return true;
        }
        return false;
    }

    public boolean isOwner() {
        return this.lock.isHeldByCurrentThread();
    }

    public Thread owner() {
        return this.lock.getOwner();
    }

    public int nWaiters() {
        return this.lock.getQueueLength();
    }

    public LatchStats getLatchStats() {
        LatchStats s = null;
        try {
            s = (LatchStats)this.stats.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return s;
    }

    public String toString() {
        return this.lock.toString();
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch(boolean checkHeld) {
        if (checkHeld) {
            return LatchSupport.latchTable.unNoteLatch(this, this.name);
        }
        LatchSupport.latchTable.unNoteLatch(this, this.name);
        return true;
    }

    private static class JEReentrantLock
    extends ReentrantLock {
        JEReentrantLock(boolean fair) {
            super(fair);
        }

        @Override
        protected Thread getOwner() {
            return super.getOwner();
        }
    }
}

