/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

public class DbFileSummary
implements Loggable {
    public int totalINCount;
    public int totalINSize;
    public int totalLNCount;
    public int totalLNSize;
    public int obsoleteINCount;
    public int obsoleteLNCount;
    public int obsoleteLNSize;
    public int obsoleteLNSizeCounted;

    public boolean isEmpty() {
        return this.totalLNCount == 0 && this.totalINCount == 0 && this.obsoleteINCount == 0 && this.obsoleteLNCount == 0;
    }

    public int getObsoleteLNSize() {
        if (this.totalLNCount == 0) {
            return 0;
        }
        int obsolete = this.obsoleteLNSize;
        int notCounted = this.obsoleteLNCount - this.obsoleteLNSizeCounted;
        if (notCounted > 0) {
            long total = this.totalLNSize;
            long avgSizePerLN = (total <<= 8) / (long)this.totalLNCount;
            obsolete += (int)((long)notCounted * avgSizePerLN >> 8);
        }
        return obsolete;
    }

    public int getObsoleteINSize() {
        if (this.totalINCount == 0) {
            return 0;
        }
        long size = this.totalINSize;
        long avgSizePerIN = (size <<= 8) / (long)this.totalINCount;
        return (int)((long)this.obsoleteINCount * avgSizePerIN >> 8);
    }

    public int getObsoleteSize() {
        return this.getObsoleteLNSize() + this.getObsoleteINSize();
    }

    public int getNonObsoleteCount() {
        return this.totalLNCount + this.totalINCount - this.obsoleteLNCount - this.obsoleteINCount;
    }

    public void reset() {
        this.totalINCount = 0;
        this.totalINSize = 0;
        this.totalLNCount = 0;
        this.totalLNSize = 0;
        this.obsoleteINCount = 0;
        this.obsoleteLNCount = 0;
        this.obsoleteLNSize = 0;
        this.obsoleteLNSizeCounted = 0;
    }

    public void add(DbFileSummary o) {
        this.totalINCount += o.totalINCount;
        this.totalINSize += o.totalINSize;
        this.totalLNCount += o.totalLNCount;
        this.totalLNSize += o.totalLNSize;
        this.obsoleteINCount += o.obsoleteINCount;
        this.obsoleteLNCount += o.obsoleteLNCount;
        this.obsoleteLNSize += o.obsoleteLNSize;
        this.obsoleteLNSizeCounted += o.obsoleteLNSizeCounted;
    }

    @Override
    public int getLogSize() {
        return LogUtils.getPackedIntLogSize(this.totalINCount) + LogUtils.getPackedIntLogSize(this.totalINSize) + LogUtils.getPackedIntLogSize(this.totalLNCount) + LogUtils.getPackedIntLogSize(this.totalLNSize) + LogUtils.getPackedIntLogSize(this.obsoleteINCount) + LogUtils.getPackedIntLogSize(this.obsoleteLNCount) + LogUtils.getPackedIntLogSize(this.obsoleteLNSize) + LogUtils.getPackedIntLogSize(this.obsoleteLNSizeCounted);
    }

    @Override
    public void writeToLog(ByteBuffer buf) {
        LogUtils.writePackedInt(buf, this.totalINCount);
        LogUtils.writePackedInt(buf, this.totalINSize);
        LogUtils.writePackedInt(buf, this.totalLNCount);
        LogUtils.writePackedInt(buf, this.totalLNSize);
        LogUtils.writePackedInt(buf, this.obsoleteINCount);
        LogUtils.writePackedInt(buf, this.obsoleteLNCount);
        LogUtils.writePackedInt(buf, this.obsoleteLNSize);
        LogUtils.writePackedInt(buf, this.obsoleteLNSizeCounted);
    }

    @Override
    public void readFromLog(ByteBuffer buf, byte entryTypeVersion) {
        this.totalINCount = LogUtils.readPackedInt(buf);
        this.totalINSize = LogUtils.readPackedInt(buf);
        this.totalLNCount = LogUtils.readPackedInt(buf);
        this.totalLNSize = LogUtils.readPackedInt(buf);
        this.obsoleteINCount = LogUtils.readPackedInt(buf);
        this.obsoleteLNCount = LogUtils.readPackedInt(buf);
        this.obsoleteLNSize = LogUtils.readPackedInt(buf);
        this.obsoleteLNSizeCounted = LogUtils.readPackedInt(buf);
    }

    @Override
    public void dumpLog(StringBuffer buf, boolean verbose) {
        buf.append("<summary totalINCount=\"");
        buf.append(this.totalINCount);
        buf.append("\" totalINSize=\"");
        buf.append(this.totalINSize);
        buf.append("\" totalLNCount=\"");
        buf.append(this.totalLNCount);
        buf.append("\" totalLNSize=\"");
        buf.append(this.totalLNSize);
        buf.append("\" obsoleteINCount=\"");
        buf.append(this.obsoleteINCount);
        buf.append("\" obsoleteLNCount=\"");
        buf.append(this.obsoleteLNCount);
        buf.append("\" obsoleteLNSize=\"");
        buf.append(this.obsoleteLNSize);
        buf.append("\" obsoleteLNSizeCounted=\"");
        buf.append(this.obsoleteLNSizeCounted);
        buf.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.dumpLog(buf, true);
        return buf.toString();
    }
}

