/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.channel.pool;

import com.gemantic.memcached.channel.MemcachedChannel;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.pool.ObjectPool;

public class MemcachedChannelPoolableObject
implements MemcachedChannel {
    private MemcachedChannel channel;
    private ObjectPool pool;
    private boolean health = true;

    public boolean isHealth() {
        return this.health;
    }

    @Override
    public void setHealth(boolean health) {
        this.health = health;
    }

    public MemcachedChannelPoolableObject(MemcachedChannel channel, ObjectPool pool) {
        this.pool = pool;
        this.channel = channel;
    }

    @Override
    public void close() throws IOException {
        try {
            this.pool.returnObject((Object)this);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.channel.flush();
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    @Override
    public boolean isAlive() {
        boolean bResult = this.channel.isAlive();
        if (!bResult) {
            this.setHealth(false);
        }
        return bResult;
    }

    @Override
    public boolean isConnected() {
        boolean bResult = this.channel.isConnected();
        if (!bResult) {
            this.setHealth(false);
        }
        return bResult;
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.channel.write(b);
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    @Override
    public void clearEOL() throws IOException {
        try {
            this.channel.clearEOL();
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    @Override
    public int read(byte[] buf) throws IOException {
        try {
            return this.channel.read(buf);
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    @Override
    public String readLine() throws IOException {
        try {
            return this.channel.readLine();
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    public void trueClose() throws Exception {
        this.channel.close();
    }

    @Override
    public void clearEnd() throws IOException {
        try {
            this.channel.clearEnd();
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    @Override
    public String readKeys(String keys) throws IOException {
        try {
            return this.channel.readKeys(keys);
        }
        catch (IOException e) {
            this.setHealth(false);
            throw e;
        }
    }

    @Override
    public DataInputStream getIn() {
        return this.channel.getIn();
    }
}

