/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.channel;

import com.gemantic.memcached.channel.MemcachedChannel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedChannelImpl
implements MemcachedChannel {
    private static Logger log = LoggerFactory.getLogger(MemcachedChannelImpl.class);
    private Socket socket;
    private DataInputStream in;
    private BufferedOutputStream out;
    private boolean health = true;

    public MemcachedChannelImpl(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new BufferedOutputStream(socket.getOutputStream());
    }

    @Override
    public DataInputStream getIn() {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Closing socket for real: " + this.toString());
        }
        boolean err = false;
        StringBuilder errMsg = new StringBuilder();
        if (this.in == null || this.out == null || this.socket == null) {
            err = true;
            errMsg.append("socket or its streams already null in trueClose call");
            return;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                log.error("error closing input stream for socket: " + ObjectUtils.toString((Object)this.socket, (String)""));
                log.error(ioe.getMessage(), (Throwable)ioe);
                errMsg.append("error closing input stream for socket: ").append(ObjectUtils.toString((Object)this.socket, (String)"")).append("\n");
                errMsg.append(ioe.getMessage());
                err = true;
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                log.error("error closing output stream for socket: " + ObjectUtils.toString((Object)this.socket, (String)""));
                log.error(ioe.getMessage(), (Throwable)ioe);
                errMsg.append("error closing output stream for socket: " + ObjectUtils.toString((Object)this.socket, (String)"") + "\n");
                errMsg.append(ioe.getMessage());
                err = true;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
                log.error("error closing output stream for socket: " + this.socket.toString());
                log.error(ioe.getMessage(), (Throwable)ioe);
                errMsg.append("error closing output stream for socket: " + this.socket.toString() + "\n");
                errMsg.append(ioe.getMessage());
                err = true;
            }
        }
        this.in = null;
        this.out = null;
        this.socket = null;
        if (err) {
            throw new IOException(errMsg.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("attempting to write to closed socket");
        }
        this.out.flush();
    }

    @Override
    public boolean isAlive() {
        if (!this.isConnected()) {
            return false;
        }
        try {
            this.write("version\r\n".getBytes());
            this.flush();
            String string = this.readLine();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.checkSocket()) {
            log.error("attempting to write to closed socket");
            throw new IOException("attempting to write to closed socket");
        }
        this.out.write(b);
    }

    @Override
    public void clearEOL() throws IOException {
        if (!this.checkSocket()) {
            log.error("attempting to read from closed socket");
            throw new IOException("attempting to read from closed socket");
        }
        byte[] b = new byte[1];
        boolean eol = false;
        while (this.in.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
                continue;
            }
            if (!eol) continue;
            if (b[0] == 10) break;
            eol = false;
        }
    }

    public void clearEOL1() throws IOException {
        if (!this.checkSocket()) {
            log.error("attempting to read from closed socket");
            throw new IOException("attempting to read from closed socket");
        }
        byte[] b = new byte[1];
        boolean eol = false;
        while (this.in.read(b, 0, 1) != -1 && b[0] != 10) {
        }
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int count;
        int cnt;
        if (!this.checkSocket()) {
            log.error("attempting to read from closed socket");
            throw new IOException("attempting to read from closed socket");
        }
        for (count = 0; count < buf.length; count += cnt) {
            cnt = this.in.read(buf, count, buf.length - count);
        }
        return count;
    }

    @Override
    public String readLine() throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            log.error("++++ attempting to read from closed socket");
            throw new IOException("++++ attempting to read from closed socket");
        }
        byte[] b = new byte[1];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean eol = false;
        while (this.in.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
            } else if (eol) {
                if (b[0] == 10) break;
                eol = false;
            }
            bos.write(b, 0, 1);
        }
        if (bos == null || bos.size() <= 0) {
            throw new IOException("Stream appears to be dead, so closing it down");
        }
        return bos.toString().trim();
    }

    public boolean checkSocket() {
        return this.socket != null && this.socket.isConnected();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MemcachedChannelImpl[");
        buffer.append("socket = ").append(this.socket);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public void clearEnd() throws IOException {
        if (!this.checkSocket()) {
            log.error("attempting to read from closed socket");
            throw new IOException("attempting to read from closed socket");
        }
        int len = "END".getBytes().length;
        byte[] keyByte = new byte[len];
        int writeLen = this.in.read(keyByte, 0, len);
        byte[] b = new byte[1];
        boolean eol = false;
        while (writeLen == len && this.in.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
                continue;
            }
            if (!eol) continue;
            if (b[0] == 10) break;
            eol = false;
        }
    }

    @Override
    public String readKeys(String key) throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            log.error("++++ attempting to read from closed socket");
            throw new IOException("++++ attempting to read from closed socket");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int len = key.getBytes().length + "VALUE".getBytes().length;
        byte[] keyByte = new byte[len];
        int writeLen = this.in.read(keyByte, 0, len);
        if (writeLen != -1) {
            bos.write(keyByte, 0, writeLen);
        }
        byte[] b = new byte[1];
        boolean eol = false;
        if (writeLen == len && keyByte[writeLen - 2] != 13 && keyByte[writeLen - 1] != 0) {
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                bos.write(b, 0, 1);
            }
        }
        if (bos == null || bos.size() <= 0) {
            throw new IOException("Stream appears to be dead, so closing it down");
        }
        return bos.toString().trim();
    }

    @Override
    public void setHealth(boolean health) {
        this.health = health;
    }
}

