/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dmemcached.route.strategy;

import com.gemantic.dal.cache.config.model.KeyPatternItem;
import com.gemantic.dal.cache.exception.StrategyException;
import com.gemantic.dal.cache.route.strategy.IStrategy;
import com.gemantic.dmemcached.config.helper.CacheConfigHelper;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStrategy
implements IStrategy {
    private static Logger logger = LoggerFactory.getLogger(DefaultStrategy.class);

    @Override
    public Object playStrategy(String regionName, Object key) throws StrategyException {
        if (StringUtils.isEmpty((String)regionName)) {
            throw new StrategyException("region name must have a value");
        }
        if (key == null) {
            throw new StrategyException("key must have a value");
        }
        Map<String, KeyPatternItem> keyPatternMap = CacheConfigHelper.getKeyKeyPatternItems(regionName);
        if (MapUtils.isEmpty(keyPatternMap)) {
            logger.warn("don't find KeyPatternItems of the " + regionName + " , begin use default set!");
            keyPatternMap = CacheConfigHelper.getDefaultKeyKeyPatternItems();
        }
        if (MapUtils.isEmpty(keyPatternMap)) {
            return null;
        }
        KeyPatternItem keyPatternItem = this.findPatternItem(keyPatternMap, key);
        return keyPatternItem != null ? keyPatternItem.getDatasource() : null;
    }

    private KeyPatternItem findPatternItem(Map<String, KeyPatternItem> patternMap, Object key) {
        KeyPatternItem patternItem = null;
        Collection<KeyPatternItem> patternItems = patternMap.values();
        for (KeyPatternItem item : patternItems) {
            Pattern pattern;
            String value;
            if (item == null || !StringUtils.isNotEmpty((String)(value = item.getValue())) || !(pattern = Pattern.compile(value)).matcher(ObjectUtils.toString((Object)key)).find()) continue;
            patternItem = item;
            break;
        }
        return patternItem != null ? patternItem : patternItems.iterator().next();
    }
}

