/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.cache;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.cache.exception.CacheException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang.StringUtils;

public final class MaxIdHolder {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private static Map<String, Long> maxIdMap = new ConcurrentHashMap<String, Long>();
    private static Long DEFAULT_MAXID = Long.MAX_VALUE;
    private static Cache cache = null;
    private static final Long RANGE = new Long(500L);
    public static Map<String, Integer> getting = new ConcurrentHashMap<String, Integer>(150);
    private static ExecutorService executorGetService = Executors.newFixedThreadPool(10);
    private static ThreadPoolExecutor executorSetService = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
    private static Integer VALUE;

    public static void setRegionName(String regionName) {
        contextHolder.set(regionName);
    }

    public static void setMaxId(String max_key, Long maxId) {
        Long storeMaxId;
        if (StringUtils.isNotEmpty((String)max_key) && (null == (storeMaxId = MaxIdHolder.getMaxId(max_key)) || storeMaxId < maxId)) {
            maxIdMap.put(max_key, maxId);
            RemoteSet remoteSet = new RemoteSet(max_key, maxId);
            executorSetService.execute(remoteSet);
        }
    }

    public static Long getMaxId(String max_key) {
        Long maxId = null;
        if (StringUtils.isNotEmpty((String)max_key)) {
            maxId = maxIdMap.get(max_key);
            if (!getting.containsKey(max_key)) {
                try {
                    getting.put(max_key, VALUE);
                    RemoteGet get = new RemoteGet(max_key);
                    executorGetService.execute(get);
                }
                finally {
                    getting.remove(max_key);
                }
            }
        }
        return maxId == null ? DEFAULT_MAXID : maxId + RANGE;
    }

    public static void clear() {
        contextHolder.remove();
    }

    static {
        executorSetService.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                RemoteSet remoteSet = (RemoteSet)r;
                if (remoteSet != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("set key ").append(remoteSet.getKey()).append(" value ").append(remoteSet.getValue()).append(" fail.");
                }
            }
        });
        VALUE = new Integer(1);
    }

    private static class RemoteGet
    implements Runnable {
        private String key;

        public RemoteGet(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            try {
                Object value;
                if (null != cache && (value = cache.get(this.key)) != null) {
                    Long vLong = (Long)value;
                    maxIdMap.put(this.key, vLong);
                }
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    private static class RemoteSet
    implements Runnable {
        private String key;
        private Object value;

        public RemoteSet(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void run() {
            try {
                if (null != cache && this.value != null) {
                    Long maxId = (Long)maxIdMap.get(this.key);
                    if ((Long)this.value >= maxId) {
                        cache.put(this.key, this.value);
                    }
                }
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }
}

