/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.raw.RawField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class FieldInfo
implements RawField,
Serializable,
Comparable<FieldInfo> {
    private static final long serialVersionUID = 2062721100372306296L;
    private String name;
    private String className;
    private Format format;
    private transient Class cls;

    static List<FieldInfo> getInstanceFields(Class cls, ClassMetadata clsMeta) {
        Collection<FieldMetadata> persistentFields;
        ArrayList<FieldInfo> fields = null;
        if (clsMeta != null && (persistentFields = clsMeta.getPersistentFields()) != null) {
            fields = new ArrayList<FieldInfo>(persistentFields.size());
            String clsName = cls.getName();
            for (FieldMetadata fieldMeta : persistentFields) {
                Field field;
                if (!clsName.equals(fieldMeta.getDeclaringClassName())) {
                    throw new IllegalArgumentException("Persistent field " + fieldMeta + " must be declared in " + clsName);
                }
                try {
                    field = cls.getDeclaredField(fieldMeta.getName());
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Persistent field " + fieldMeta + " is not declared in this class");
                }
                if (!field.getType().getName().equals(fieldMeta.getClassName())) {
                    throw new IllegalArgumentException("Persistent field " + fieldMeta + " must be of type " + field.getType().getName());
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalArgumentException("Persistent field " + fieldMeta + " may not be static");
                }
                fields.add(new FieldInfo(field));
            }
        }
        if (fields == null) {
            Field[] declaredFields = cls.getDeclaredFields();
            fields = new ArrayList(declaredFields.length);
            for (Field field : declaredFields) {
                int mods = field.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                fields.add(new FieldInfo(field));
            }
        }
        return fields;
    }

    static FieldInfo getField(List<FieldInfo> fields, String fieldName) {
        int i = FieldInfo.getFieldIndex(fields, fieldName);
        if (i >= 0) {
            return fields.get(i);
        }
        return null;
    }

    static int getFieldIndex(List<FieldInfo> fields, String fieldName) {
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo field = fields.get(i);
            if (!fieldName.equals(field.getName())) continue;
            return i;
        }
        return -1;
    }

    private FieldInfo(Field field) {
        this.name = field.getName();
        this.cls = field.getType();
        this.className = this.cls.getName();
    }

    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        this.format = catalog.createFormat(this.cls, newFormats);
    }

    void migrateFromBeta(Map<String, Format> formatMap) {
        if (this.format == null) {
            this.format = formatMap.get(this.className);
            if (this.format == null) {
                throw new IllegalStateException(this.className);
            }
        }
    }

    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        if (this.format != null && this.format.isNew()) {
            this.format = catalog.getFormat(this.className);
        }
    }

    Class getFieldClass() {
        if (this.cls == null) {
            try {
                this.cls = SimpleCatalog.classForName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.cls;
    }

    String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Format getType() {
        return this.format;
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object other) {
        if (other instanceof FieldInfo) {
            FieldInfo o = (FieldInfo)other;
            return this.name.equals(o.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[Field name: " + this.name + " class: " + this.className + ']';
    }
}

