/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class EnumFormat
extends Format {
    private static final long serialVersionUID = 1069833955604373538L;
    private String[] names;
    private transient Object[] values;

    EnumFormat(Class type) {
        super(type);
        this.values = type.getEnumConstants();
        this.names = new String[this.values.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = ((Enum)this.values[i]).name();
        }
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public List<String> getEnumConstants() {
        return Arrays.asList(this.names);
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        Class cls;
        if (this.values == null && (cls = this.getType()) != null) {
            this.values = new Object[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.values[i] = Enum.valueOf(cls, this.names[i]);
            }
        }
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        int index = input.readEnumConstant(this.names);
        if (rawAccess) {
            return new RawObject((RawType)this, this.names[index]);
        }
        return this.values[index];
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        if (rawAccess) {
            String name = ((RawObject)o).getEnum();
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equals(name)) continue;
                output.writeEnumConstant(this.names, i);
                return;
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (o != this.values[i]) continue;
                output.writeEnumConstant(this.names, i);
                return;
            }
        }
        throw new IllegalStateException("Bad enum: " + o);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        String name = rawObject.getEnum();
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            Object o = this.values[i];
            converted.put(rawObject, o);
            return o;
        }
        throw new IllegalArgumentException("Enum constant is not defined: " + name);
    }

    @Override
    void skipContents(RecordInput input) {
        input.skipFast(input.getPackedIntByteLength());
    }

    @Override
    boolean evolve(Format newFormatParam, Evolver evolver) {
        if (!(newFormatParam instanceof EnumFormat)) {
            evolver.addEvolveError(this, newFormatParam, "Incompatible enum type changed detected", "An enum class may not be changed to a non-enum type");
            return false;
        }
        EnumFormat newFormat = (EnumFormat)newFormatParam;
        if (Arrays.equals(this.names, newFormat.names)) {
            evolver.useOldFormat(this, newFormat);
            return true;
        }
        HashSet<String> oldNames = new HashSet<String>(Arrays.asList(this.names));
        List<String> newNames = Arrays.asList(newFormat.names);
        if (newNames.containsAll(oldNames)) {
            evolver.useEvolvedFormat(this, newFormat, newFormat);
            return true;
        }
        oldNames.removeAll(newNames);
        evolver.addEvolveError(this, newFormat, "Incompatible enum type changed detected", "Enum values may not be removed: " + oldNames);
        return false;
    }
}

